/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.CommandLineException;
import fit.CommandLineParseException;
import fit.Parameters;
import junit.framework.TestCase;

public class ParametersTest
extends TestCase {
    public void testInputAndOutput() throws Exception {
        Parameters parameters = new Parameters(new String[]{"in", "out"});
        ParametersTest.assertEquals((String)"in", (String)parameters.input());
        ParametersTest.assertEquals((String)"out", (String)parameters.output());
    }

    public void testLegacyArguments_NoteThatThisMethodSucksAndWillGoAwayAsSoonAsPossible() throws Exception {
        Parameters parameters = new Parameters(new String[]{"--encoding=foo", "in", "out"});
        String[] stringArray = parameters.legacyArguments();
        ParametersTest.assertEquals((int)2, (int)stringArray.length);
        ParametersTest.assertEquals((String)"in", (String)stringArray[0]);
        ParametersTest.assertEquals((String)"out", (String)stringArray[1]);
    }

    public void testDefaultEncoding() throws Exception {
        Parameters parameters = new Parameters(new String[]{"in", "out"});
        ParametersTest.assertEquals((String)System.getProperty("file.encoding"), (String)parameters.encoding());
        ParametersTest.assertEquals((String)"encoding unspecified", (boolean)false, (boolean)parameters.encodingSpecified());
        ParametersTest.assertEquals((String)"encoding specified", (boolean)true, (boolean)new Parameters(new String[]{"in", "out", "--encoding=foo"}).encodingSpecified());
    }

    public void testOptionsWorkInAnyPosition() throws Exception {
        this.assertParseWorked("--encoding=foo", "in", "out");
        this.assertParseWorked("in", "--encoding=foo", "out");
        this.assertParseWorked("in", "out", "--encoding=foo");
    }

    private void assertParseWorked(String string, String string2, String string3) throws CommandLineException {
        Parameters parameters = new Parameters(new String[]{string, string2, string3});
        ParametersTest.assertEquals((String)"in", (String)parameters.input());
        ParametersTest.assertEquals((String)"out", (String)parameters.output());
        ParametersTest.assertEquals((String)"foo", (String)parameters.encoding());
    }

    public void testDoubleDash() throws Exception {
        Parameters parameters = new Parameters(new String[]{"--encoding=foo", "--", "in", "--encoding=foo"});
        ParametersTest.assertEquals((String)"in", (String)parameters.input());
        ParametersTest.assertEquals((String)"--encoding=foo", (String)parameters.output());
        ParametersTest.assertEquals((String)"foo", (String)parameters.encoding());
    }

    public void testOptionParser() throws Exception {
        ParametersTest.assertEquals((String)"foo", (String)this.newParameters("--encoding=foo").encoding());
        ParametersTest.assertEquals((String)"foo bar", (String)this.newParameters("--encoding=foo bar").encoding());
        ParametersTest.assertEquals((String)"foo=bar", (String)this.newParameters("--encoding=foo=bar").encoding());
        ParametersTest.assertEquals((String)"foo-bar", (String)this.newParameters("--encoding=foo-bar").encoding());
    }

    public void testArgumentErrorHandling() throws Exception {
        this.assertParseException("fit: missing input-file and output-file", new String[0]);
        this.assertParseException("fit: missing output-file", new String[]{"in"});
        this.assertParseException("fit: too many file parameters", new String[]{"in", "out", "quack"});
        this.assertParseException("fit: --encoding: duplicated parameter", new String[]{"in", "out", "--encoding=a", "--encoding=b"});
        this.assertParseException("fit: --notparm: unknown option", new String[]{"in", "out", "--encoding=a", "--notparm=b"});
        this.assertParseException("fit: --notparm: unknown option", new String[]{"in", "out", "--notparm=a", "--notparm=b"});
    }

    public void testOptionErrorHandling() throws Exception {
        this.assertParseException("fit: too many file parameters", "=foo");
        this.assertParseException("fit: -encoding: unknown option", "-encoding=foo");
        this.assertParseException("fit: --notparm: unknown option", "--notparm=blah");
        this.assertParseException("fit: --notparm: unknown option", "--notparm");
        this.assertParseException("fit: -: unknown option", "-");
        this.assertParseException("fit: --encoding: missing value", "--encoding");
        this.assertParseException("fit: --encoding: missing value", "--encoding=");
    }

    public void testVersion() throws Exception {
        try {
            this.newParameters("--version");
            ParametersTest.fail((String)"expected exception");
        }
        catch (CommandLineException commandLineException) {
            ParametersTest.assertEquals((String)"Fit for Java v1.1+changes\nConforms to Fit Specification v1.1+changes\nCopyright (C) 2008 Cunningham & Cunningham, Inc.\nLicense GPLv2+: GNU GPL version 2 or later\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n", (String)commandLineException.getMessage());
        }
    }

    public void testHelp() throws Exception {
        try {
            this.newParameters("--help");
            ParametersTest.fail((String)"expected exception");
        }
        catch (CommandLineException commandLineException) {
            ParametersTest.assertEquals((String)"usage: java fit.FileRunner [options] input-file output-file\n\nOptions\n --encoding=CHARSET     read and write files using specified character set\n --version              print version number\n --help                 show this help screen\n\nSee http://fit.c2.com for further information and to report bugs\n", (String)commandLineException.getMessage());
        }
    }

    private Parameters newParameters(String string) throws CommandLineException {
        return new Parameters(new String[]{"in", "out", string});
    }

    private void assertParseException(String string, String string2) throws CommandLineException {
        this.assertParseException(string, new String[]{"in", "out", string2});
    }

    private void assertParseException(String string, String[] stringArray) throws CommandLineException {
        try {
            Parameters parameters = new Parameters(stringArray);
            ParametersTest.fail((String)"expected exception");
        }
        catch (CommandLineParseException commandLineParseException) {
            ParametersTest.assertEquals((String)string, (String)commandLineParseException.getMessage());
        }
    }
}

