/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.CommandLineException;
import fit.CommandLineParseException;

public class Parameters {
    static final String HELP_TEXT = "usage: java fit.FileRunner [options] input-file output-file\n\nOptions\n --encoding=CHARSET     read and write files using specified character set\n --version              print version number\n --help                 show this help screen\n\nSee http://fit.c2.com for further information and to report bugs\n";
    static final String VERSION_TEXT = "Fit for Java v1.1+changes\nConforms to Fit Specification v1.1+changes\nCopyright (C) 2008 Cunningham & Cunningham, Inc.\nLicense GPLv2+: GNU GPL version 2 or later\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n";
    private boolean shouldParseOptions = true;
    private String input = null;
    private String output = null;
    private String encoding = null;

    public String input() {
        return this.input;
    }

    public String output() {
        return this.output;
    }

    public String encoding() {
        return this.encodingSpecified() ? this.encoding : System.getProperty("file.encoding");
    }

    public boolean encodingSpecified() {
        return this.encoding != null;
    }

    public String[] legacyArguments() {
        return new String[]{this.input(), this.output()};
    }

    public Parameters(String[] stringArray) throws CommandLineException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("--")) {
                this.shouldParseOptions = false;
                continue;
            }
            if (string.startsWith("-") && this.shouldParseOptions) {
                this.parseOption(string);
                continue;
            }
            if (this.input == null) {
                this.input = string;
                continue;
            }
            if (this.output == null) {
                this.output = string;
                continue;
            }
            throw new CommandLineParseException("too many file parameters");
        }
        if (this.input == null) {
            throw new CommandLineParseException("missing input-file and output-file");
        }
        if (this.output == null) {
            throw new CommandLineParseException("missing output-file");
        }
    }

    private void parseOption(String string) throws CommandLineException {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(61);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (!string2.equals("--encoding")) {
            if (string2.equals("--version")) {
                throw new CommandLineException(VERSION_TEXT);
            }
            if (string2.equals("--help")) {
                throw new CommandLineException(HELP_TEXT);
            }
            throw new CommandLineParseException(string2 + ": unknown option");
        }
        this.parseEncoding(string3);
    }

    private void parseEncoding(String string) throws CommandLineException {
        if (string == null || "".equals(string)) {
            throw new CommandLineParseException("--encoding: missing value");
        }
        if (this.encodingSpecified()) {
            throw new CommandLineParseException("--encoding: duplicated parameter");
        }
        this.encoding = string;
    }
}

