/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.Counts;
import fit.Parse;
import fit.ScientificDouble;
import fit.TypeAdapter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class Fixture {
    public Map summary = new HashMap();
    public Counts counts = new Counts();
    protected String[] args;
    public static String green = "#cfffcf";
    public static String red = "#ffcfcf";
    public static String gray = "#efefef";
    public static String yellow = "#ffffcf";
    static /* synthetic */ Class class$java$lang$reflect$InvocationTargetException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$fit$ScientificDouble;

    public void doTables(Parse parse) {
        Parse parse2;
        this.summary.put("run date", new Date());
        this.summary.put("run elapsed time", new RunTime());
        if (parse != null && (parse2 = this.fixtureName(parse)) != null) {
            try {
                Fixture fixture = this.getLinkedFixtureWithArgs(parse);
                fixture.interpretTables(parse);
            }
            catch (Exception exception) {
                this.exception(parse2, exception);
                this.interpretFollowingTables(parse);
            }
        }
    }

    protected void interpretTables(Parse parse) {
        try {
            this.getArgsForTable(parse);
            this.doTable(parse);
        }
        catch (Exception exception) {
            this.exception(this.fixtureName(parse), exception);
            return;
        }
        this.interpretFollowingTables(parse);
    }

    private void interpretFollowingTables(Parse parse) {
        parse = parse.more;
        while (parse != null) {
            Parse parse2 = this.fixtureName(parse);
            if (parse2 != null) {
                try {
                    Fixture fixture = this.getLinkedFixtureWithArgs(parse);
                    fixture.doTable(parse);
                }
                catch (Throwable throwable) {
                    this.exception(parse2, throwable);
                }
            }
            parse = parse.more;
        }
    }

    protected Fixture getLinkedFixtureWithArgs(Parse parse) throws Exception {
        Parse parse2 = parse.at(0, 0, 0);
        Fixture fixture = this.loadFixture(parse2.text());
        fixture.counts = this.counts;
        fixture.summary = this.summary;
        fixture.getArgsForTable(parse);
        return fixture;
    }

    public Parse fixtureName(Parse parse) {
        return parse.at(0, 0, 0);
    }

    public Fixture loadFixture(String string) throws InstantiationException, IllegalAccessException {
        String string2 = "The fixture \"" + string + "\" was not found.";
        try {
            return this.getFixtureInstanceOf(string);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("\"" + string + "\" was found, but it's not a fixture.", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(string2, classNotFoundException);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new RuntimeException(string2, noClassDefFoundError);
        }
    }

    protected void getArgsForTable(Parse parse) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Parse parse2 = parse.parts.parts.more;
        while (parse2 != null) {
            arrayList.add(parse2.text());
            parse2 = parse2.more;
        }
        this.args = arrayList.toArray(new String[0]);
    }

    public void doTable(Parse parse) {
        this.doRows(parse.parts.more);
    }

    public void doRows(Parse parse) {
        while (parse != null) {
            Parse parse2 = parse.more;
            this.doRow(parse);
            parse = parse2;
        }
    }

    public void doRow(Parse parse) {
        this.doCells(parse.parts);
    }

    public void doCells(Parse parse) {
        int n = 0;
        while (parse != null) {
            try {
                this.doCell(parse, n);
            }
            catch (Exception exception) {
                this.exception(parse, exception);
            }
            parse = parse.more;
            ++n;
        }
    }

    public void doCell(Parse parse, int n) {
        this.ignore(parse);
    }

    public void right(Parse parse) {
        parse.addToTag(" bgcolor=\"" + green + "\"");
        ++this.counts.right;
    }

    public void wrong(Parse parse) {
        parse.addToTag(" bgcolor=\"" + red + "\"");
        parse.body = Fixture.escape(parse.text());
        ++this.counts.wrong;
    }

    public void wrong(Parse parse, String string) {
        this.wrong(parse);
        parse.addToBody(Fixture.label("expected") + "<hr>" + Fixture.escape(string) + Fixture.label("actual"));
    }

    public void info(Parse parse, String string) {
        parse.addToBody(this.info(string));
    }

    public String info(String string) {
        return " <font color=\"#808080\">" + Fixture.escape(string) + "</font>";
    }

    public void ignore(Parse parse) {
        parse.addToTag(" bgcolor=\"" + gray + "\"");
        ++this.counts.ignores;
    }

    public void error(Parse parse, String string) {
        parse.body = Fixture.escape(parse.text());
        parse.addToBody("<hr><pre>" + Fixture.escape(string) + "</pre>");
        parse.addToTag(" bgcolor=\"" + yellow + "\"");
        ++this.counts.exceptions;
    }

    public void exception(Parse parse, Throwable throwable) {
        while (throwable.getClass().equals(class$java$lang$reflect$InvocationTargetException == null ? Fixture.class$("java.lang.reflect.InvocationTargetException") : class$java$lang$reflect$InvocationTargetException)) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        this.error(parse, stringWriter.toString());
    }

    public String counts() {
        return this.counts.toString();
    }

    public static String label(String string) {
        return " <font size=-1 color=\"#c08080\"><i>" + string + "</i></font>";
    }

    public static String escape(String string) {
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll("  ", " &nbsp;");
        string = string.replaceAll("\r\n", "<br />");
        string = string.replaceAll("\r", "<br />");
        string = string.replaceAll("\n", "<br />");
        return string;
    }

    public static String camel(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            return string;
        }
        stringBuffer.append(stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2.substring(0, 1).toUpperCase());
            stringBuffer.append(string2.substring(1));
        }
        return stringBuffer.toString();
    }

    public Object parse(String string, Class clazz) throws Exception {
        if (clazz.equals(class$java$lang$String == null ? (class$java$lang$String = Fixture.class$("java.lang.String")) : class$java$lang$String)) {
            return string;
        }
        if (clazz.equals(class$java$util$Date == null ? (class$java$util$Date = Fixture.class$("java.util.Date")) : class$java$util$Date)) {
            return DateFormat.getDateInstance().parse(string);
        }
        if (clazz.equals(class$fit$ScientificDouble == null ? (class$fit$ScientificDouble = Fixture.class$("fit.ScientificDouble")) : class$fit$ScientificDouble)) {
            return ScientificDouble.valueOf(string);
        }
        throw new Exception("can't yet parse " + clazz);
    }

    public void check(Parse parse, TypeAdapter typeAdapter) {
        String string = parse.text();
        if (string.equals("")) {
            try {
                this.info(parse, typeAdapter.toString(typeAdapter.get()));
            }
            catch (Exception exception) {
                this.info(parse, "error");
            }
        } else if (typeAdapter == null) {
            this.ignore(parse);
        } else if (string.equals("error")) {
            try {
                Object object = typeAdapter.invoke();
                this.wrong(parse, typeAdapter.toString(object));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.exception(parse, illegalAccessException);
            }
            catch (Exception exception) {
                this.right(parse);
            }
        } else {
            try {
                Object object = typeAdapter.get();
                if (typeAdapter.equals(typeAdapter.parse(string), object)) {
                    this.right(parse);
                } else {
                    this.wrong(parse, typeAdapter.toString(object));
                }
            }
            catch (Exception exception) {
                this.exception(parse, exception);
            }
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public Fixture getFixtureInstanceOf(String string) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return (Fixture)Thread.currentThread().getContextClassLoader().loadClass(string).newInstance();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RunTime {
        long start = System.currentTimeMillis();
        long elapsed = 0L;

        public String toString() {
            this.elapsed = System.currentTimeMillis() - this.start;
            if (this.elapsed > 600000L) {
                return this.d(3600000L) + ":" + this.d(600000L) + this.d(60000L) + ":" + this.d(10000L) + this.d(1000L);
            }
            return this.d(60000L) + ":" + this.d(10000L) + this.d(1000L) + "." + this.d(100L) + this.d(10L);
        }

        String d(long l) {
            long l2 = this.elapsed / l;
            this.elapsed -= l2 * l;
            return Long.toString(l2);
        }
    }
}

