/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.CommandLineException;
import fit.Fixture;
import fit.Parameters;
import fit.Parse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class FileRunner {
    private static String encoding;
    public String input;
    public Parse tables;
    public Fixture fixture = new Fixture();
    public PrintWriter output;

    public static void main(String[] stringArray) {
        try {
            new FileRunner().run(stringArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("fit: " + unsupportedEncodingException.getMessage() + ": unsupported encoding");
            System.exit(-1);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(-1);
        }
    }

    public void run(String[] stringArray) throws IOException, CommandLineException {
        Parameters parameters = new Parameters(stringArray);
        if (encoding == null || parameters.encodingSpecified()) {
            encoding = parameters.encoding();
        }
        this.args(parameters.legacyArguments());
        this.process();
        this.exit();
    }

    public void process() {
        try {
            if (this.input.indexOf("<wiki>") >= 0) {
                this.tables = new Parse(this.input, new String[]{"wiki", "table", "tr", "td"});
                this.fixture.doTables(this.tables.parts);
            } else {
                this.tables = new Parse(this.input, new String[]{"table", "tr", "td"});
                this.fixture.doTables(this.tables);
            }
        }
        catch (Exception exception) {
            this.exception(exception);
        }
        this.tables.print(this.output);
    }

    public void args(String[] stringArray) throws IOException {
        if (stringArray.length != 2) {
            System.err.println("usage: java fit.FileRunner input-file output-file");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        File file2 = new File(stringArray[1]);
        this.fixture.summary.put("input file", file.getAbsolutePath());
        this.fixture.summary.put("input update", new Date(file.lastModified()));
        this.fixture.summary.put("output file", file2.getAbsolutePath());
        this.input = this.read(file);
        this.output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), encoding));
    }

    protected String read(File file) throws IOException {
        char[] cArray = new char[(int)file.length()];
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        inputStreamReader.read(cArray);
        ((Reader)inputStreamReader).close();
        return new String(cArray);
    }

    protected void exception(Exception exception) {
        this.tables = new Parse("body", "Unable to parse input. Input ignored.", null, null);
        this.fixture.exception(this.tables, exception);
    }

    protected void exit() {
        this.output.close();
        System.err.println(this.fixture.counts());
        System.exit(this.fixture.counts.wrong + this.fixture.counts.exceptions);
    }
}

