/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ListDiff {
    Set left;
    Set right;
    Set leftOnly = new HashSet();
    Set rightOnly = new HashSet();
    Set both = new HashSet();
    boolean computed;

    public ListDiff(Collection left, Collection right) {
        this.left = new HashSet();
        this.right = new HashSet();
        this.left.addAll(left);
        this.right.addAll(right);
        this.computed = false;
    }

    private void doCompute() {
        if (!this.computed) {
            HashSet hlp = new HashSet();
            hlp.addAll(this.left);
            hlp.addAll(this.right);
            Iterator i = hlp.iterator();
            while (i.hasNext()) {
                Object anEntry = i.next();
                boolean inLeft = this.left.contains(anEntry);
                boolean inRight = this.right.contains(anEntry);
                if (inLeft && inRight) {
                    this.both.add(anEntry);
                    continue;
                }
                if (inLeft) {
                    this.leftOnly.add(anEntry);
                    continue;
                }
                this.rightOnly.add(anEntry);
            }
            this.left = null;
            this.right = null;
            this.computed = true;
        }
    }

    public boolean hasDiffs() {
        this.doCompute();
        return this.leftOnly.size() > 0 || this.rightOnly.size() > 0;
    }

    public Set getBoth() {
        this.doCompute();
        return this.both;
    }

    public Set getLeftOnly() {
        this.doCompute();
        return this.leftOnly;
    }

    public Set getRightOnly() {
        this.doCompute();
        return this.rightOnly;
    }
}

