/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.swing;

import fit.guirunner.SortingEntry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableSortCoordinator
extends MouseAdapter {
    protected JTable view;
    private PropertyChangeSupport sortChanged;
    HashMap sortColumns = new HashMap();
    int lastX = -1;

    public TableSortCoordinator(JTable table) {
        this.view = table;
        this.sortChanged = new PropertyChangeSupport(this);
    }

    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed()) {
            TableColumnModel colModel = this.view.getColumnModel();
            int columnModelIndex = colModel.getColumnIndexAtX(e.getX());
            int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
            int columnWidth = colModel.getColumn(columnModelIndex).getWidth();
            if (modelIndex >= 0 && !this.isMoving(columnWidth, e.getX(), this.lastX)) {
                String headerName = this.view.getModel().getColumnName(modelIndex);
                if (e.isControlDown()) {
                    this.multiSort(modelIndex, headerName);
                } else {
                    this.singleSort(modelIndex, headerName);
                }
                for (int i = 0; i < colModel.getColumnCount(); ++i) {
                    String newTitle;
                    TableColumn c = colModel.getColumn(i);
                    Integer identifier = new Integer(c.getModelIndex());
                    String string = newTitle = this.sortColumns.containsKey(identifier) ? ((SortingEntry)this.sortColumns.get(identifier)).getHeaderTitle() : this.view.getModel().getColumnName(c.getModelIndex());
                    if (newTitle.equals(c.getHeaderValue())) continue;
                    c.setHeaderValue(newTitle);
                }
                this.view.getTableHeader().repaint();
                this.view.getSelectionModel().clearSelection();
                this.sortChanged.firePropertyChange("default", null, this.sortColumns);
            }
            e.consume();
        }
    }

    private void singleSort(int modelIndex, String headerName) {
        Integer id = new Integer(modelIndex);
        if (this.sortColumns.size() == 1 && this.sortColumns.containsKey(id)) {
            SortingEntry se = (SortingEntry)this.sortColumns.get(id);
            se.toggle();
            if (se.getSortingDirection() == 0) {
                this.sortColumns.clear();
            }
        } else {
            this.sortColumns.clear();
            SortingEntry se = new SortingEntry(modelIndex, 1, headerName);
            this.sortColumns.put(new Integer(modelIndex), se);
        }
    }

    private void multiSort(int modelIndex, String headerTitle) {
        Integer id = new Integer(modelIndex);
        if (this.sortColumns.containsKey(id)) {
            ((SortingEntry)this.sortColumns.get(id)).toggle2();
        } else {
            SortingEntry se = new SortingEntry(modelIndex, this.sortColumns.size() + 1, headerTitle);
            this.sortColumns.put(id, se);
        }
    }

    private boolean isMoving(int columnWidth, int x, int lastX) {
        return Math.abs(x - lastX) > columnWidth / 10;
    }

    public void mousePressed(MouseEvent e) {
        this.lastX = e.getX();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.sortChanged.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.sortChanged.removePropertyChangeListener(listener);
    }
}

