/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class ColoredIntegerCellRenderer
extends DefaultTableCellRenderer {
    private Color nonzeroColor;
    private Color selectedNonzeroColor;
    private static final Integer ZERO = new Integer(0);
    private Border compoundBorder;

    public ColoredIntegerCellRenderer(Color nonzeroColor) {
        this.nonzeroColor = nonzeroColor;
        this.selectedNonzeroColor = nonzeroColor.brighter();
        this.setHorizontalAlignment(4);
        this.compoundBorder = null;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color bg;
        Color fg;
        Component theComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean nzColor = false;
        if (value != null && value instanceof Integer) {
            boolean bl = nzColor = !ZERO.equals(value);
        }
        if (isSelected) {
            fg = nzColor ? table.getForeground() : table.getSelectionForeground();
            bg = nzColor ? this.selectedNonzeroColor : table.getSelectionBackground();
        } else {
            bg = nzColor ? this.nonzeroColor : table.getBackground();
            fg = table.getForeground();
        }
        theComponent.setBackground(bg);
        theComponent.setForeground(fg);
        if (this.compoundBorder == null) {
            this.compoundBorder = new CompoundBorder(new EmptyBorder(1, 4, 1, 4), ((JLabel)theComponent).getBorder());
        }
        ((JLabel)theComponent).setBorder(this.compoundBorder);
        return theComponent;
    }
}

