/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.logic;

import fit.guirunner.logic.SimpleWildcardFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class FileFind {
    FilenameFilter filter;

    public FileFind(String pattern) {
        this.filter = new SimpleWildcardFilter(pattern);
    }

    public FileFind(FilenameFilter filter) {
        this.filter = filter;
    }

    public List execute(String startDir) {
        return this.execute(new File(startDir));
    }

    public List execute(File startDir) {
        LinkedList result = new LinkedList();
        if (startDir.isDirectory()) {
            try {
                this.expand(startDir.getCanonicalFile(), result);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    protected void expand(File path, List result) {
        File[] files = path.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (this.filter.accept(path, files[i].getName())) {
                    try {
                        result.add(files[i].getCanonicalFile());
                    }
                    catch (IOException e) {
                        e.printStackTrace(System.err);
                    }
                }
                if (!files[i].isDirectory()) continue;
                this.expand(files[i], result);
            }
        }
    }
}

