/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.logic;

import fit.guirunner.RunnerEntry;
import fit.guirunner.logic.StreamToStringList;
import fit.guirunner.logic.VariableExpansion;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecuteEntry {
    String commandLine;
    String workingDirectoryPattern;
    File inDir;
    File outDir;
    File workingDirectory;
    boolean outputParsed = false;
    String right = null;
    String wrong = null;
    String ignored = null;
    String exceptions = null;
    Pattern regexp;
    private transient Process theTest;
    private boolean killed;

    public ExecuteEntry(String commandLine, String workingDirectoryPattern, File workingDirectory, File inDir, File outDir) {
        this.commandLine = commandLine;
        this.workingDirectoryPattern = workingDirectoryPattern;
        this.workingDirectory = workingDirectory;
        this.inDir = inDir;
        this.outDir = outDir;
        this.regexp = Pattern.compile("(\\d+) right, (\\d+) wrong, (\\d+) ignore[sd], (\\d+) exceptions");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(RunnerEntry re) {
        String wdName;
        File testWd;
        File outFilename = ExecuteEntry.generateOutputFilename(this.inDir, this.outDir, re.getInFile());
        StringBuffer cmdOutput = new StringBuffer();
        VariableExpansion strrep = new VariableExpansion("infile", re.getInFile().getAbsolutePath(), "outfile", outFilename.getAbsolutePath(), "infiledir", re.getInFile().getParentFile().getAbsolutePath(), "outdir", this.outDir.getAbsolutePath(), "indir", this.inDir.getAbsolutePath());
        File testWorkingDir = this.workingDirectory;
        if (this.workingDirectoryPattern != null && !"".equals(this.workingDirectoryPattern) && (testWd = new File(wdName = strrep.replace(this.workingDirectoryPattern))).isDirectory()) {
            testWorkingDir = testWd;
        }
        String cmdLine = strrep.replace(this.commandLine);
        cmdOutput.append(cmdLine).append("\n");
        this.outputParsed = false;
        long elapsed = System.currentTimeMillis();
        try {
            File parentDir = outFilename.getParentFile();
            if (!parentDir.isDirectory()) {
                parentDir.mkdirs();
            }
            ExecuteEntry executeEntry = this;
            synchronized (executeEntry) {
                this.theTest = Runtime.getRuntime().exec(cmdLine, null, testWorkingDir);
                this.killed = false;
            }
            StreamToStringList stdout = new StreamToStringList(this.theTest.getInputStream());
            StreamToStringList stderr = new StreamToStringList(this.theTest.getErrorStream());
            this.theTest.getOutputStream().close();
            stdout.start();
            stderr.start();
            this.theTest.waitFor();
            ExecuteEntry executeEntry2 = this;
            synchronized (executeEntry2) {
                this.theTest = null;
            }
            stderr.join();
            stdout.join();
            this.parseOutput(cmdOutput, stderr.getLines());
            this.parseOutput(cmdOutput, stdout.getLines());
        }
        catch (IOException e) {
            cmdOutput.append(e.toString());
        }
        catch (InterruptedException e) {
            cmdOutput.append(e.toString());
        }
        ExecuteEntry executeEntry = this;
        synchronized (executeEntry) {
            if (this.killed) {
                cmdOutput.append("\n[fit.GuiRunner message: process was killed by User]\n");
            }
        }
        elapsed = System.currentTimeMillis() - elapsed;
        re.setElapsed(elapsed);
        re.setLastRunTimestamp();
        if (this.outputParsed) {
            re.setParseableResult(cmdOutput.toString(), Integer.parseInt(this.right), Integer.parseInt(this.wrong), Integer.parseInt(this.ignored), Integer.parseInt(this.exceptions));
            re.setLastOutFile(outFilename);
        } else {
            re.setUnparseableResult(cmdOutput.toString());
            re.setLastOutFile(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killTest() {
        ExecuteEntry executeEntry = this;
        synchronized (executeEntry) {
            if (this.theTest != null) {
                this.killed = true;
                this.theTest.destroy();
            }
        }
    }

    private void parseOutput(StringBuffer cmdOutput, Iterator lines) throws IOException {
        while (lines.hasNext()) {
            Matcher m;
            String line = (String)lines.next();
            cmdOutput.append(line).append("\n");
            if (this.outputParsed || !(m = this.regexp.matcher(line)).matches()) continue;
            this.right = m.group(1);
            this.wrong = m.group(2);
            this.ignored = m.group(3);
            this.exceptions = m.group(4);
            this.outputParsed = true;
        }
    }

    public static File generateOutputFilename(File inDir, File outDir, File inFile) {
        StringBuffer sb = new StringBuffer(outDir.getAbsolutePath().length() + inFile.getAbsolutePath().length());
        sb.append(outDir.getAbsolutePath());
        sb.append(System.getProperties().getProperty("file.separator"));
        sb.append(inFile.getAbsolutePath().substring(inDir.getAbsolutePath().length()));
        return new File(sb.toString());
    }
}

