/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.actions.AbstractAsyncAction;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ResultsToClipboardAction
extends AbstractAsyncAction
implements TableModelListener {
    JTable view;

    public ResultsToClipboardAction(GlobalLockCoordinator lockCoordinator, JTable view) {
        this.view = view;
        view.getModel().addTableModelListener(this);
        this.setLockCoordinator(lockCoordinator);
    }

    public void doActionPerformed(ActionEvent e) {
        Clipboard clipboard = this.view.getToolkit().getSystemClipboard();
        StringSelection transData = new StringSelection(this.getExportString());
        clipboard.setContents(transData, transData);
    }

    protected boolean isActionEnabled() {
        return this.view.getRowCount() > 0;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateEnabled();
    }

    public void tableChanged(TableModelEvent e) {
        this.setEnabled(this.view.getModel().getRowCount() > 0);
    }

    public String getExportString() {
        StringBuffer sb = new StringBuffer(this.view.getRowCount() * 256);
        for (int col = 0; col < this.view.getColumnCount(); ++col) {
            int modelIdx = this.view.convertColumnIndexToModel(col);
            if (!this.columnToExport(modelIdx)) continue;
            sb.append(this.view.getModel().getColumnName(modelIdx));
            sb.append("\t");
        }
        sb.append("\n");
        for (int row = 0; row < this.view.getRowCount(); ++row) {
            for (int col = 0; col < this.view.getColumnCount(); ++col) {
                if (!this.columnToExport(this.view.convertColumnIndexToModel(col))) continue;
                Object value = this.view.getValueAt(row, col);
                sb.append(value == null ? "" : value).append("\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private boolean columnToExport(int modelIndex) {
        return modelIndex != 0 && modelIndex != 3;
    }
}

