/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.Configuration;
import fit.guirunner.EnvironmentContext;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.actions.AbstractAsyncAction;
import fit.guirunner.logic.FileFind;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ReloadAction
extends AbstractAsyncAction {
    RunnerTableModel model;
    Resources resources;

    public ReloadAction(RunnerTableModel model, Resources resources) {
        this.model = model;
        this.resources = resources;
        this.setLockCoordinator(resources.getLockCoordinator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActionPerformed(ActionEvent e) {
        this.getLockCoordinator().setReadingFilesystem(true);
        Configuration config = this.resources.getConfiguration();
        FileFind fileFind = new FileFind(config.getPattern());
        try {
            EnvironmentContext ctx = new EnvironmentContext(config);
            List latest = this.files2entries(ctx, fileFind.execute(ctx.getInDir()));
            this.model.setNewEntries(latest);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            this.getLockCoordinator().setReadingFilesystem(false);
        }
    }

    private List files2entries(EnvironmentContext ctx, List files) {
        LinkedList<RunnerEntry> result = new LinkedList<RunnerEntry>();
        Iterator i = files.iterator();
        while (i.hasNext()) {
            File inFile = (File)i.next();
            String relativePath = ReloadAction.generateRelativePath(ctx.getInDir(), inFile);
            result.add(new RunnerEntry(inFile, relativePath));
        }
        return result;
    }

    public static String generateRelativePath(File inDir, File inFile) {
        String hlp = inFile.getParentFile().getAbsolutePath();
        int dirnameLen = inDir.getAbsolutePath().length();
        int startIdx = dirnameLen == hlp.length() ? dirnameLen : dirnameLen + 1;
        return hlp.substring(startIdx);
    }

    protected boolean isActionEnabled() {
        return this.getLockCoordinator().canReadFilesystem();
    }
}

