/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.EnvironmentContext;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.actions.AbstractCurrentEntryAction;
import fit.guirunner.logic.VariableExpansion;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;

public class OpenOutputFileAction
extends AbstractCurrentEntryAction {
    Resources resources;

    public OpenOutputFileAction(JTable view, GlobalLockCoordinator lockCoordinator, Resources resources) {
        super(view, lockCoordinator);
        this.resources = resources;
    }

    public void doActionPerformed(ActionEvent e) {
        try {
            RunnerEntry re = this.getRunnerEntry();
            EnvironmentContext ctx = new EnvironmentContext(this.resources.getConfiguration());
            VariableExpansion strrep = new VariableExpansion("outfile", re.getLastOutFile().getAbsolutePath());
            String cmd = strrep.replace(ctx.getOpenCmd());
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void valueChanged(ListSelectionEvent arg0) {
        this.handleChanged();
    }

    public void tableChanged(TableModelEvent arg0) {
        if (arg0.getType() == 0) {
            this.handleChanged();
        }
    }

    public void handleChanged() {
        int row = this.view.getSelectedRow();
        boolean enabled = false;
        if (row >= 0 && row < this.view.getRowCount()) {
            RunnerEntry re = this.getRunnerEntry();
            enabled = re != null && this.isOutputFileAvailable(re);
        }
        this.setEnabled(enabled);
    }

    private boolean isOutputFileAvailable(RunnerEntry re) {
        return re.hasBeenRun() && re.getLastOutFile() != null && re.getLastOutFile().exists();
    }
}

