/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.EnvironmentContext;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.NewTestfileDialog;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.actions.AbstractAsyncAction;
import fit.guirunner.actions.ReloadAction;
import fit.guirunner.logic.SimpleWildcardFilter;
import fit.guirunner.logic.VariableExpansion;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class NewTestAction
extends AbstractAsyncAction {
    public static final String TEMPLATE_NAME = "fit/guirunner/resource/NewTestTemplate.html";
    public static final String TEMPLATE_ENCODING = "cp1252";
    public static final String KEY_TITLE = "title.NewTestfile";
    Resources resource;
    RunnerTableModel model;

    public NewTestAction(GlobalLockCoordinator lockCoordinator, Resources resource, RunnerTableModel model) {
        this.setLockCoordinator(lockCoordinator);
        this.resource = resource;
        this.model = model;
    }

    public void doActionPerformed(ActionEvent e) {
        SimpleWildcardFilter validator = new SimpleWildcardFilter(this.resource.getConfiguration().getPattern());
        try {
            EnvironmentContext environmentContext = new EnvironmentContext(this.resource.getConfiguration());
            String dlgTitle = this.resource.getResource().getResourceString(KEY_TITLE);
            NewTestfileDialog dlg = new NewTestfileDialog(this.resource, environmentContext, validator, dlgTitle);
            dlg.pack();
            dlg.setLocationRelativeTo(this.resource.getApplicationFrame());
            dlg.setVisible(true);
            File newFile = dlg.getSelectedNewFile();
            if (newFile != null) {
                this.saveTestTemplate(newFile);
                RunnerEntry re = new RunnerEntry(newFile, ReloadAction.generateRelativePath(environmentContext.getInDir(), newFile));
                this.model.addEntry(re);
                VariableExpansion strrep = new VariableExpansion("infile", newFile.getAbsolutePath());
                String cmd = strrep.replace(environmentContext.getEditCmd());
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected boolean isActionEnabled() {
        return !this.getLockCoordinator().isRunnerIsRunning() && !this.getLockCoordinator().isReadingFilesystem();
    }

    private void saveTestTemplate(File newFile) throws UnsupportedEncodingException, FileNotFoundException {
        String template = RunnerResourceBundle.readResourceFile(TEMPLATE_NAME, TEMPLATE_ENCODING);
        VariableExpansion ve = new VariableExpansion("title", newFile.getName());
        template = ve.replace(template);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        PrintWriter output = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), TEMPLATE_ENCODING));
        output.write(template);
        output.close();
    }
}

