/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.EnvironmentContext;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.NewTestfileDialog;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.actions.AbstractCurrentEntryAction;
import fit.guirunner.actions.ReloadAction;
import fit.guirunner.logic.SimpleWildcardFilter;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JTable;

public class MoveOrRenameTestAction
extends AbstractCurrentEntryAction {
    public static final String KEY_TITLE = "title.RenameMoveTestfile";
    Resources resource;
    RunnerTableModel model;

    public MoveOrRenameTestAction(JTable view, GlobalLockCoordinator lockCoordinator, Resources resource, RunnerTableModel model) {
        super(view, lockCoordinator);
        this.resource = resource;
        this.model = model;
    }

    public void doActionPerformed(ActionEvent e) {
        SimpleWildcardFilter validator = new SimpleWildcardFilter(this.resource.getConfiguration().getPattern());
        try {
            RunnerEntry currentRunnerEntry = this.getRunnerEntry();
            EnvironmentContext environmentContext = new EnvironmentContext(this.resource.getConfiguration());
            String dlgTitle = this.resource.getResource().getResourceString(KEY_TITLE);
            NewTestfileDialog dlg = new NewTestfileDialog(this.resource, environmentContext, validator, dlgTitle);
            dlg.setCurrentFile(currentRunnerEntry.getInFile());
            dlg.pack();
            dlg.setLocationRelativeTo(this.resource.getApplicationFrame());
            dlg.setVisible(true);
            File newFile = dlg.getSelectedNewFile();
            if (newFile != null) {
                currentRunnerEntry.getInFile().renameTo(newFile);
                this.model.removeEntry(currentRunnerEntry);
                RunnerEntry re = new RunnerEntry(newFile, ReloadAction.generateRelativePath(environmentContext.getInDir(), newFile));
                this.model.addEntry(re);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    protected boolean isActionEnabled() {
        return !this.getLockCoordinator().isRunnerIsRunning() && !this.getLockCoordinator().isReadingFilesystem();
    }
}

