/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.EnvironmentContext;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.actions.AbstractAsyncAction;
import fit.guirunner.logic.ExecuteEntry;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public abstract class AbstractRunEntriesAction
extends AbstractAsyncAction
implements ListSelectionListener,
TableModelListener {
    Resources resources;
    JTable view;
    RunnerTableModel model;
    private boolean stopped;
    private transient ExecuteEntry execute;

    public AbstractRunEntriesAction(JTable view, GlobalLockCoordinator lockCoordinator, Resources resources, RunnerTableModel model) {
        this.view = view;
        this.resources = resources;
        this.model = model;
        this.setLockCoordinator(lockCoordinator);
        view.getSelectionModel().addListSelectionListener(this);
        view.getModel().addTableModelListener(this);
        this.setEnabled(false);
    }

    public void valueChanged(ListSelectionEvent arg0) {
    }

    public void tableChanged(TableModelEvent arg0) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doActionPerformed(ActionEvent e) {
        try {
            this.getLockCoordinator().setRunnerIsRunning(this);
            this.run(this.getEntriesToRun());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            this.getLockCoordinator().setRunnerIsRunning(null);
        }
    }

    protected abstract List getEntriesToRun();

    protected boolean isActionEnabled() {
        return this.getLockCoordinator().canRun();
    }

    protected void run(List entries) throws IOException {
        this.newExecuteEntry();
        this.stopped = false;
        Iterator i = entries.iterator();
        while (!this.stopped && i.hasNext()) {
            RunnerEntry re = (RunnerEntry)i.next();
            re.setRunning();
            this.model.modifyEntry(re);
            this.getExecuteEntry().doExecute(re);
            this.model.modifyEntry(re);
        }
        this.releaseExecuteEntry();
    }

    private synchronized void releaseExecuteEntry() {
        this.execute = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newExecuteEntry() throws IOException {
        EnvironmentContext ctx = new EnvironmentContext(this.resources.getConfiguration());
        AbstractRunEntriesAction abstractRunEntriesAction = this;
        synchronized (abstractRunEntriesAction) {
            this.execute = new ExecuteEntry(ctx.getRunnerCmd(), ctx.getWorkDirPattern(), ctx.getWorkingDir(), ctx.getInDir(), ctx.getOutDir());
        }
    }

    private synchronized ExecuteEntry getExecuteEntry() {
        return this.execute;
    }

    public void stopTests() {
        this.stopped = true;
    }

    public synchronized void killCurrentTest() {
        this.stopTests();
        if (this.execute != null) {
            this.execute.killTest();
        }
    }
}

