/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.RunnerResourceBundle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class AbstractAsyncAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private ActionEvent actionEvent;
    private boolean locked = false;
    private boolean externalEnabled = true;
    protected GlobalLockCoordinator lockCoordinator;

    public AbstractAsyncAction() {
    }

    public AbstractAsyncAction(String name) {
        super(name);
    }

    public AbstractAsyncAction(String name, Icon icon) {
        super(name, icon);
    }

    public AbstractAsyncAction(RunnerResourceBundle resources, String key) {
        this();
        resources.configureActionFromResource(this, key);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (this.isEnabled()) {
            this.actionEvent = arg0;
            SwingUtilities.invokeLater(this);
        }
    }

    public abstract void doActionPerformed(ActionEvent var1);

    public void run() {
        Thread h = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AbstractAsyncAction.this.setLocked(true);
                    AbstractAsyncAction.this.doActionPerformed(AbstractAsyncAction.this.actionEvent);
                    AbstractAsyncAction.this.actionEvent = null;
                }
                finally {
                    AbstractAsyncAction.this.setLocked(false);
                }
            }
        };
        h.start();
    }

    protected boolean isActionEnabled() {
        return true;
    }

    public final boolean isLocked() {
        return this.locked;
    }

    protected final void updateEnabled() {
        super.setEnabled(this.externalEnabled && !this.locked && this.isActionEnabled());
    }

    public final void setEnabled(boolean b) {
        if (this.externalEnabled != b) {
            this.externalEnabled = b;
            this.updateEnabled();
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.updateEnabled();
    }

    protected void setLocked(boolean b) {
        if (b != this.locked) {
            this.locked = b;
            this.updateEnabled();
        }
    }

    public void setLockCoordinator(GlobalLockCoordinator lc) {
        if (this.lockCoordinator != null) {
            this.lockCoordinator.removePropertyChangeListener(this);
            this.lockCoordinator = null;
        }
        if (lc != null) {
            this.lockCoordinator = lc;
            lc.addPropertyChangeListener(this);
            this.updateEnabled();
        }
    }

    protected GlobalLockCoordinator getLockCoordinator() {
        return this.lockCoordinator;
    }
}

