/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner.actions;

import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.RunnerVersion;
import fit.guirunner.logic.VariableExpansion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

class AboutDialog
extends JDialog
implements RunnerVersion {
    public static final String DEFAULT_RESOURCES = "fit/guirunner/resource/";
    public static final String DEFAULT_ABOUT = "about.html";
    public static final String RESOURCE_ENCODING = "iso-8859-1";

    public AboutDialog(JFrame parent) {
        super((Frame)parent, true);
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                AboutDialog.this.dispose();
            }
        };
        this.setDefaultCloseOperation(2);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JButton ok = new JButton("ok");
        ok.addActionListener(closeAction);
        this.getRootPane().setDefaultButton(ok);
        JPanel hlp = new JPanel();
        hlp.setLayout(new FlowLayout(1));
        hlp.add(ok);
        pane.add((Component)hlp, "South");
        JEditorPane info = new JEditorPane();
        info.setEditorKit(new HTMLEditorKit());
        info.setEditable(false);
        info.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Runtime.getRuntime().exec("cmd /C start \"dummy...\" " + e.getURL().toExternalForm());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        info.setText(this.getAboutText());
        pane.add((Component)info, "Center");
        KeyStroke escKey = KeyStroke.getKeyStroke("ESCAPE");
        InputMap im = this.getRootPane().getInputMap(2);
        im.put(escKey, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", closeAction);
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        info.getInputMap().put(enterKey, closeAction);
    }

    private String getAboutText() {
        String defaultAboutString = "<html><body><b>fit.GuiRunner</b><p><a href=\"http://fit.c2.com\">fit.c2.com</a><br>written by Martin Busik<br>&copy; 2007</p></body></html>";
        String language = Locale.getDefault().getLanguage();
        String result = RunnerResourceBundle.readResourceFile(DEFAULT_RESOURCES + language + "_" + DEFAULT_ABOUT, RESOURCE_ENCODING);
        if (result == null) {
            result = RunnerResourceBundle.readResourceFile("fit/guirunner/resource/about.html", RESOURCE_ENCODING);
        }
        if (result == null) {
            result = defaultAboutString;
        }
        VariableExpansion exp = new VariableExpansion("version", "010", "ID", "$Id: RunnerVersion.java,v 1.7 2008/06/09 09:08:27 mbusik Exp $");
        result = exp.replace(result);
        return result;
    }
}

