/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class UserPreferences {
    public static final String KEY_FRAME_POS = "frame.pos";
    public static final String KEY_FRAME_SIZE = "frame.size";
    public static final String KEY_USERLAYOUT_TABLE_COLUMNS = "table.columns";
    public static final String KEY_TABLE_SIZE = "table.size";
    public static final String KEY_SCROLL_SIZE = "scroll.size";
    public static final String KEY_MRU_PREFIX = "mru.";
    public static final String KEY_CURRENT_CONFIGURATION = "ConfigurationStorage.currentConfiguration";
    File configurationFile;
    Properties properties;

    public UserPreferences(String filename) {
        this(new File(filename));
    }

    public UserPreferences(File file) {
        this.configurationFile = file;
        if (file.canRead()) {
            this.lazyLoad();
        }
    }

    public String getProperty(String key) {
        this.lazyLoad();
        return this.properties.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lazyLoad() {
        if (this.properties != null) return;
        this.properties = new Properties();
        FileInputStream fis = null;
        fis = new FileInputStream(this.configurationFile);
        this.properties.load(fis);
        Object var4_2 = null;
        if (fis == null) return;
        try {
            fis.close();
            return;
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return;
        {
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Object var4_3 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var4_4 = null;
                if (fis == null) return;
                try {
                    fis.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (fis == null) throw throwable;
            try {
                fis.close();
                throw throwable;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }

    public void storeProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.put(key, value);
        this.storeProperties();
    }

    public void updateProperties(Properties newProperties, List propertiesToDelete) {
        Iterator<Map.Entry<Object, Object>> i = newProperties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> me = i.next();
            this.properties.put(me.getKey(), me.getValue());
        }
        if (propertiesToDelete != null && propertiesToDelete.size() > 0) {
            i = propertiesToDelete.iterator();
            while (i.hasNext()) {
                this.properties.remove(i.next());
            }
        }
        this.storeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void storeProperties() {
        block14: {
            FileOutputStream fos = null;
            fos = new FileOutputStream(this.configurationFile);
            this.properties.store(fos, null);
            Object var4_2 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block14;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            break block14;
            {
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    Object var4_3 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block14;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var4_4 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block14;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void storePosition(String key, Point pt) {
        this.storeProperty(key, pt.x + "," + pt.y);
    }

    public void storeSize(String key, Dimension d) {
        this.storeProperty(key, d.width + "," + d.height);
    }

    public Point loadPosition(String key) {
        String[] xy;
        String p = this.getProperty(key);
        Point result = null;
        if (p != null && (xy = p.split(",")) != null && xy.length == 2) {
            int x = Integer.parseInt(xy[0]);
            int y = Integer.parseInt(xy[1]);
            result = new Point(x, y);
        }
        return result;
    }

    public Dimension loadSize(String key) {
        String[] xy;
        String p = this.getProperty(key);
        Dimension result = null;
        if (p != null && (xy = p.split(",")) != null && xy.length == 2) {
            int x = Integer.parseInt(xy[0]);
            int y = Integer.parseInt(xy[1]);
            if (x > 0 && y > 0) {
                result = new Dimension(x, y);
            }
        }
        return result;
    }
}

