/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

public class SortingEntry {
    public static final int ASC = 1;
    public static final int DESC = -1;
    public static final int NONE = 0;
    int modelIndex;
    int sortingDirection;
    int sortingPosition;
    String columnName;

    public SortingEntry(int modelIndex, int sortingPosition, String columnName) {
        this.modelIndex = modelIndex;
        this.sortingPosition = sortingPosition;
        this.columnName = columnName;
        this.sortingDirection = 1;
    }

    public int toggle() {
        switch (this.sortingDirection) {
            case 1: {
                this.sortingDirection = -1;
                break;
            }
            case -1: {
                this.sortingDirection = 0;
                break;
            }
            case 0: {
                this.sortingDirection = 1;
            }
        }
        return this.sortingDirection;
    }

    public int toggle2() {
        this.sortingDirection = this.sortingDirection == 1 ? -1 : 1;
        return this.sortingDirection;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public int getSortingDirection() {
        return this.sortingDirection;
    }

    public String getHeaderTitle() {
        String suffix = "";
        if (this.sortingDirection == 1) {
            suffix = " [^ " + this.sortingPosition + "]";
        }
        if (this.sortingDirection == -1) {
            suffix = " [v " + this.sortingPosition + "]";
        }
        return this.columnName + suffix;
    }
}

