/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.RunnerTableModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SortedTableModel
extends AbstractTableModel
implements TableModelListener,
PropertyChangeListener {
    private boolean isSorted = false;
    private boolean isDirty = false;
    private Integer[] view2model;
    private int[] model2view;
    private Comparator theComparator;
    private RunnerTableModel theModel;
    private HashMap sortedColumns;
    private GlobalLockCoordinator lockCoordinator;

    public SortedTableModel(GlobalLockCoordinator lockCoordinator, RunnerTableModel theModel) {
        this.theModel = theModel;
        theModel.addTableModelListener(this);
        this.view2model = new Integer[0];
        this.model2view = new int[0];
        this.sortedColumns = new HashMap();
        this.lockCoordinator = lockCoordinator;
    }

    public int getColumnCount() {
        return this.theModel.getColumnCount();
    }

    public int getRowCount() {
        return this.theModel.getRowCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int idx = this.isSorted ? this.view2model[rowIndex] : rowIndex;
        return this.theModel.getValueAt(idx, columnIndex);
    }

    public void tableChanged(TableModelEvent e) {
        this.tableChangedWithDirty(e);
    }

    public void tableChangedNoDirty(TableModelEvent e) {
        if (this.isSorted) {
            if (e.getType() == 0 && e.getColumn() != -1) {
                if (this.sortedColumns.containsKey(new Integer(e.getColumn())) || e.getFirstRow() != e.getLastRow()) {
                    this.updateView2ModelMap();
                } else {
                    int rowIdxInView = this.model2view[e.getFirstRow()];
                    TableModelEvent tme = new TableModelEvent((TableModel)e.getSource(), rowIdxInView, rowIdxInView, e.getColumn(), e.getType());
                    this.fireTableChanged(tme);
                }
            } else {
                this.updateView2ModelMap();
            }
        } else {
            this.fireTableChanged(e);
        }
    }

    public void tableChangedWithDirty(TableModelEvent e) {
        if (this.isSorted) {
            if (e.getType() == 0 && e.getColumn() != -1) {
                if (this.sortedColumns.containsKey(new Integer(e.getColumn())) || e.getFirstRow() != e.getLastRow()) {
                    this.updateDirty(true);
                    this.fireTableChanged(new TableModelEvent(this.theModel, 0, this.theModel.getRowCount() - 1));
                } else {
                    int rowIdxInView = this.model2view[e.getFirstRow()];
                    TableModelEvent tme = new TableModelEvent((TableModel)e.getSource(), rowIdxInView, rowIdxInView, e.getColumn(), e.getType());
                    this.fireTableChanged(tme);
                }
            } else {
                this.updateDirty(true);
                this.fireTableChanged(new TableModelEvent(this.theModel, 0, this.theModel.getRowCount() - 1));
            }
        } else {
            this.fireTableChanged(e);
        }
    }

    public void setSortColumns(Map sortColumns) {
        if (sortColumns.size() > 0) {
            this.theComparator = this.theModel.getComparator(sortColumns);
            this.isSorted = true;
            this.updateView2ModelMap();
        } else {
            this.theComparator = null;
            this.isSorted = false;
            this.view2model = new Integer[0];
            this.updateDirty(false);
            this.fireTableChanged(new TableModelEvent(this.theModel, 0, this.theModel.getRowCount() - 1));
        }
    }

    public void actualiseSort() {
        if (this.isSorted) {
            this.updateView2ModelMap();
        }
    }

    private void updateView2ModelMap() {
        int i;
        Integer[] newOrder = this.view2model;
        if (newOrder.length != this.theModel.getRowCount()) {
            newOrder = new Integer[this.theModel.getRowCount()];
            this.model2view = new int[this.theModel.getRowCount()];
        }
        for (i = 0; i < newOrder.length; ++i) {
            newOrder[i] = new Integer(i);
        }
        Arrays.sort(newOrder, this.theComparator);
        this.view2model = newOrder;
        for (i = 0; i < newOrder.length; ++i) {
            this.model2view[newOrder[i].intValue()] = i;
        }
        this.updateDirty(false);
        this.fireTableChanged(new TableModelEvent(this.theModel, 0, this.theModel.getRowCount() - 1));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Map sortColumns = (Map)evt.getNewValue();
        this.setSortColumns(sortColumns);
    }

    public Class getColumnClass(int columnIndex) {
        return this.theModel.getColumnClass(columnIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.theModel.getColumnName(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.theModel.isCellEditable(rowIndex, columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int idx = this.isSorted ? this.view2model[rowIndex] : rowIndex;
        this.theModel.setValueAt(aValue, idx, columnIndex);
    }

    private void updateDirty(boolean newValue) {
        boolean oldValue = this.isDirty;
        this.isDirty = newValue;
        if (oldValue != newValue) {
            this.lockCoordinator.setViewOrderDirty(newValue);
        }
    }
}

