/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.IntegerAttributeComparator;
import fit.guirunner.RunnerEntriesComparator;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.SortingEntry;
import fit.guirunner.StringAttributeComparator;
import fit.guirunner.TimestampComarator;
import fit.guirunner.util.ListDiff;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class RunnerTableModel
extends AbstractTableModel {
    public static final int POS_MARK = 0;
    public static final int POS_FOLDER = 1;
    public static final int POS_NAME = 2;
    public static final int POS_STATUS = 3;
    public static final int POS_CORRECT = 4;
    public static final int POS_WRONG = 5;
    public static final int POS_IGNORED = 6;
    public static final int POS_EXCEPTIONS = 7;
    public static final int POS_ELAPSED = 8;
    public static final int POS_TIMESTAMP = 9;
    public static final int COLUMN_COUNT = 10;
    public static final int POS_ROW = 11;
    List entries;
    transient Map entriesLookup = null;
    transient Map markedEntries = null;
    List titles;
    String[] defaultTitles = new String[]{"mark", "folder", "file name", "status", "right", "wrong", "ignored", "exceptions", "elapsed", "last run"};
    static final Class[] columnClasses = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = RunnerTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = RunnerTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RunnerTableModel.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$Icon == null ? (class$javax$swing$Icon = RunnerTableModel.class$("javax.swing.Icon")) : class$javax$swing$Icon, class$java$lang$Integer == null ? (class$java$lang$Integer = RunnerTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RunnerTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RunnerTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Integer == null ? (class$java$lang$Integer = RunnerTableModel.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = RunnerTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RunnerTableModel.class$("java.lang.String")) : class$java$lang$String};
    Icon statusRunning;
    Icon statusUnparseable;
    DateFormat dateFormat;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Integer;

    public RunnerTableModel(RunnerResourceBundle bundle) {
        this.entries = new ArrayList();
        this.titles = this.loadTitles(bundle, this.defaultTitles);
        String value = bundle.getResourceString("image.status.running");
        if (value != null) {
            this.statusRunning = bundle.getImage(value);
        }
        if ((value = bundle.getResourceString("image.status.unparseable")) != null) {
            this.statusUnparseable = bundle.getImage(value);
        }
        this.dateFormat = DateFormat.getTimeInstance(3);
    }

    private List loadTitles(RunnerResourceBundle bundle, String[] defaultTitles2) {
        ArrayList<String> titles = new ArrayList<String>(defaultTitles2.length);
        for (int i = 0; i < defaultTitles2.length; ++i) {
            String key = "label.".concat(defaultTitles2[i]).replaceAll(" ", "_");
            String localised = bundle.getResourceString(key);
            titles.add(localised != null ? localised : defaultTitles2[i]);
        }
        return titles;
    }

    public List getEntries() {
        return this.entries;
    }

    public RunnerEntry getEntry(int idx) {
        return (RunnerEntry)this.entries.get(idx);
    }

    public int getColumnCount() {
        return 10;
    }

    public int getRowCount() {
        return this.entries.size();
    }

    public Object getValueAt(int arg0, int arg1) {
        RunnerEntry entry = (RunnerEntry)this.entries.get(arg0);
        return this.getAttribute(entry, arg1);
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.modifyMark(rowIndex, value);
                break;
            }
            case 3: {
                this.modifyStatus((RunnerEntry)value);
                break;
            }
            case 11: {
                this.modifyEntry((RunnerEntry)value);
                break;
            }
            default: {
                super.setValueAt(value, rowIndex, columnIndex);
            }
        }
    }

    private void modifyMark(int rowIndex, Object value) {
        RunnerEntry re = this.getEntry(rowIndex);
        re.setMark((Boolean)value);
        if (this.markedEntries == null) {
            this.updateMarked();
        }
        if (Boolean.TRUE.equals(value)) {
            this.markedEntries.put(re, Boolean.TRUE);
        } else {
            this.markedEntries.remove(re);
        }
        this.fireTableCellUpdated(rowIndex, 0);
    }

    public Class getColumnClass(int arg0) {
        return columnClasses[arg0];
    }

    public String getColumnName(int arg0) {
        return (String)this.titles.get(arg0);
    }

    private Object getAttribute(RunnerEntry entry, int column) {
        Object result;
        switch (column) {
            case 0: {
                result = entry.getMark();
                break;
            }
            case 2: {
                result = entry.getInFile().getName();
                break;
            }
            case 3: {
                result = this.getStatusIcon(entry);
                break;
            }
            case 4: {
                result = entry.getRight();
                break;
            }
            case 5: {
                result = entry.getWrong();
                break;
            }
            case 6: {
                result = entry.getIgnored();
                break;
            }
            case 7: {
                result = entry.getExceptions();
                break;
            }
            case 8: {
                result = entry.getElapsedString();
                break;
            }
            case 1: {
                result = entry.getRelativePath();
                break;
            }
            case 9: {
                result = this.getTimestamp(entry);
                break;
            }
            case 11: {
                result = entry;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTimestamp(RunnerEntry entry) {
        Date lastRun = entry.getLatRunTimestamp();
        String result = "";
        if (lastRun != null) {
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                result = this.dateFormat.format(lastRun);
            }
        }
        return result;
    }

    private Object getStatusIcon(RunnerEntry entry) {
        Icon result = null;
        switch (entry.getStatus()) {
            case 3: {
                result = this.statusRunning;
                break;
            }
            case 1: {
                result = this.statusUnparseable;
            }
        }
        return result;
    }

    public void removeAllEntries() {
        this.entries.clear();
        this.entriesLookup = null;
        this.markedEntries = null;
        this.fireTableDataChanged();
    }

    public void addEntries(Collection entries) {
        this.entries.addAll(entries);
        this.entriesLookup = null;
        this.fireTableDataChanged();
    }

    public void removeEntries(Collection entries) {
        this.entries.removeAll(entries);
        this.entriesLookup = null;
        this.markedEntries = null;
        this.fireTableDataChanged();
    }

    public void removeEntry(RunnerEntry re) {
        int idx = this.entryToRow(re);
        this.entries.remove(re);
        this.entriesLookup = null;
        this.markedEntries = null;
        this.fireTableRowsDeleted(idx, idx);
    }

    public void addEntry(RunnerEntry entry) {
        this.entries.add(entry);
        this.entriesLookup = null;
        this.markedEntries = null;
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    public void modifyEntry(RunnerEntry entry) {
        int row = this.entryToRow(entry);
        this.fireTableRowsUpdated(row, row);
    }

    public void modifyStatus(RunnerEntry entry) {
        int row = this.entryToRow(entry);
        this.fireTableCellUpdated(row, 3);
    }

    public void setQueuedToRun(List entries) {
        boolean fireAllChanged = 4 * entries.size() > this.getRowCount();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            RunnerEntry re = (RunnerEntry)i.next();
            re.setQueuedToRun();
            if (fireAllChanged) continue;
            int row = this.entryToRow(re);
            this.fireTableRowsUpdated(row, row);
        }
        if (fireAllChanged) {
            this.fireTableDataChanged();
        }
    }

    private int entryToRow(RunnerEntry entry) {
        int result;
        if (this.entriesLookup == null) {
            this.entriesLookup = new HashMap(this.entries.size());
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.entriesLookup.put(this.entries.get(i), new Integer(i));
            }
        }
        int n = result = this.entriesLookup.containsKey(entry) ? (Integer)this.entriesLookup.get(entry) : -1;
        if (result < 0) {
            throw new RuntimeException("inconsistent lookup");
        }
        return result;
    }

    public Comparator getComparator(Map sortColumns) {
        Comparator[] comparators = new Comparator[sortColumns.size()];
        boolean[] ascendingOrder = new boolean[sortColumns.size()];
        Iterator i = sortColumns.values().iterator();
        while (i.hasNext()) {
            SortingEntry se = (SortingEntry)i.next();
            comparators[se.sortingPosition - 1] = this.getComparator(se.getModelIndex());
            ascendingOrder[se.sortingPosition - 1] = se.getSortingDirection() == 1;
        }
        return new RunnerEntriesComparator(comparators, ascendingOrder, this);
    }

    public Comparator getComparator(int columnModelIndex) {
        Comparator result;
        switch (columnModelIndex) {
            case 0: {
                result = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        Boolean v1 = ((RunnerEntry)o1).getMark();
                        Boolean v2 = ((RunnerEntry)o2).getMark();
                        return v1.booleanValue() == v2.booleanValue() ? 0 : (v1 != false ? 1 : -1);
                    }
                };
                break;
            }
            case 1: 
            case 2: {
                result = new StringAttributeComparator(columnModelIndex);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                result = new IntegerAttributeComparator(columnModelIndex);
                break;
            }
            case 8: {
                result = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        long v2;
                        long v1 = ((RunnerEntry)o1).getElapsed();
                        return v1 == (v2 = ((RunnerEntry)o2).getElapsed()) ? 0 : (v1 < v2 ? -1 : 1);
                    }
                };
                break;
            }
            case 3: {
                result = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int v2;
                        int v1 = ((RunnerEntry)o1).getStatus();
                        return v1 == (v2 = ((RunnerEntry)o2).getStatus()) ? 0 : (v1 < v2 ? -1 : 1);
                    }
                };
                break;
            }
            case 9: {
                result = new TimestampComarator(columnModelIndex);
                break;
            }
            default: {
                result = new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return 0;
                    }
                };
            }
        }
        return result;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public boolean isMarkBufferEmpty() {
        if (this.markedEntries == null) {
            this.updateMarked();
        }
        return this.markedEntries.isEmpty();
    }

    private void updateMarked() {
        this.markedEntries = new HashMap(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            RunnerEntry re = (RunnerEntry)this.entries.get(i);
            if (!re.getMark().booleanValue()) continue;
            this.markedEntries.put(re, Boolean.TRUE);
        }
    }

    public void setNewEntries(List latest) {
        ListDiff diff = new ListDiff(this.entries, latest);
        if (diff.hasDiffs()) {
            this.entries.addAll(diff.getRightOnly());
            this.entries.removeAll(diff.getLeftOnly());
            this.markedEntries = null;
            this.entriesLookup = null;
            this.updateMarked();
            this.fireTableDataChanged();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

