/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.actions.AbstractAsyncAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class RunnerResourceBundle {
    ResourceBundle resource;

    public RunnerResourceBundle(String resourceName) {
        this.resource = ResourceBundle.getBundle(resourceName);
    }

    public String getResourceString(String key) {
        String result = null;
        try {
            result = this.resource.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    public ImageIcon getImage(String name) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        ImageIcon result = new ImageIcon(url);
        return result;
    }

    public Enumeration getKeys() {
        return this.resource.getKeys();
    }

    public Locale getLocale() {
        return this.resource.getLocale();
    }

    public void configureActionFromResource(AbstractAsyncAction action, String key) {
        String value = this.getResourceString("tooltip." + key);
        if (value != null) {
            action.putValue("ShortDescription", value);
        }
        if ((value = this.getResourceString("image." + key)) != null) {
            action.putValue("SmallIcon", this.getImage(value));
        }
        if ((value = this.getResourceString("text." + key)) != null) {
            action.putValue("Name", value);
        } else {
            action.putValue("Name", key);
        }
        value = this.getResourceString("mnemonic." + key);
        if (value != null) {
            if (Character.isDigit(value.charAt(0))) {
                action.putValue("MnemonicKey", new Integer(value));
            } else {
                action.putValue("MnemonicKey", new Integer(value.charAt(0)));
            }
        }
        if ((value = this.getResourceString("accelerator." + key)) != null) {
            action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(value));
        }
    }

    public void configureMenuItemFromResource(JMenuItem action, String key) {
        String value = this.getResourceString("tooltip." + key);
        if (value != null) {
            action.setToolTipText(value);
        }
        if ((value = this.getResourceString("image." + key)) != null) {
            action.setIcon(this.getImage(value));
        }
        if ((value = this.getResourceString("text." + key)) != null) {
            action.setText(value);
        }
        if ((value = this.getResourceString("mnemonic." + key)) != null && value.length() > 0) {
            if (Character.isDigit(value.charAt(0))) {
                action.setMnemonic(new Integer(value));
            } else {
                action.setMnemonic(value.charAt(0));
            }
        }
        if ((value = this.getResourceString("accelerator." + key)) != null) {
            action.setAccelerator(KeyStroke.getKeyStroke(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readResourceFile(String name, String encoding) {
        String result;
        block30: {
            IOException e222222;
            BufferedReader sr;
            InputStreamReader isr;
            InputStream is;
            block26: {
                block25: {
                    String line;
                    result = null;
                    is = null;
                    isr = null;
                    sr = null;
                    StringBuffer sb = new StringBuffer();
                    is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
                    if (is == null) break block25;
                    isr = new InputStreamReader(is, encoding);
                    sr = new BufferedReader(isr);
                    while ((line = sr.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    result = sb.toString();
                }
                Object var9_9 = null;
                if (sr == null) break block26;
                try {
                    sr.close();
                }
                catch (IOException e222222) {
                    e222222.printStackTrace();
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e222222) {
                    e222222.printStackTrace();
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e222222) {
                    e222222.printStackTrace();
                }
            }
            break block30;
            {
                catch (IOException e3) {
                    IOException e222222;
                    e3.printStackTrace();
                    Object var9_10 = null;
                    if (sr != null) {
                        try {
                            sr.close();
                        }
                        catch (IOException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e222222) {
                            e222222.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222222;
                Object var9_11 = null;
                if (sr != null) {
                    try {
                        sr.close();
                    }
                    catch (IOException e222222) {
                        e222222.printStackTrace();
                    }
                }
                if (isr != null) {
                    try {
                        isr.close();
                    }
                    catch (IOException e222222) {
                        e222222.printStackTrace();
                    }
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e222222) {
                        e222222.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
        return result;
    }
}

