/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.GuiRunnerActions;
import fit.guirunner.GuiRunnerView;
import fit.guirunner.Resources;
import fit.guirunner.RunnerMenu;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.RunnerToolbar;
import fit.guirunner.UserPreferences;
import fit.guirunner.actions.AbstractAsyncAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class RunnerFrame
extends JFrame
implements WindowListener,
GuiRunnerActions {
    Resources resources;
    String defaultTitle;
    GuiRunnerView view;
    JScrollPane scroll;

    public RunnerFrame(RunnerTableModel model, Resources resources) {
        this.resources = resources;
        this.setDefaultCloseOperation(3);
        RunnerFrame.setDefaultLookAndFeelDecorated(true);
        this.defaultTitle = resources.getResource().getResourceString("text.appname");
        resources.setApplicationFrame(this);
        this.registerExitAction(resources);
        this.view = new GuiRunnerView(model, resources);
        this.scroll = new JScrollPane(this.view);
        RunnerToolbar toolbar = new RunnerToolbar(resources);
        RunnerMenu menubar = new RunnerMenu(resources);
        this.setJMenuBar(menubar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)toolbar, "North");
        this.getContentPane().add((Component)this.scroll, "Center");
        this.restorePositionAndSize(this.view);
        this.addWindowListener(this);
        this.setKeyMapping(menubar, resources.getActionMap());
        resources.getLockCoordinator().addPropertyChangeListener("hasConfiguration", this.getConfigurationListener());
        this.updateTitle(resources.getLockCoordinator().getCurrentConfiguration());
    }

    private PropertyChangeListener getConfigurationListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                RunnerFrame.this.updateTitle((Configuration)evt.getNewValue());
            }
        };
    }

    private void updateTitle(Configuration c) {
        String newTitle = this.defaultTitle;
        if (c != null && c.getConfigurationName() != null) {
            newTitle = this.defaultTitle + " [" + c.getConfigurationName() + "]";
        }
        this.setTitle(newTitle);
    }

    private void restorePositionAndSize(JTable view) {
        Dimension d;
        UserPreferences layoutState = this.resources.getUserLayout();
        Point ps = layoutState.loadPosition("frame.pos");
        if (ps != null) {
            this.setLocation(ps);
        }
        if ((d = layoutState.loadSize("scroll.size")) != null) {
            this.scroll.setPreferredSize(d);
        } else {
            d = view.getSize();
            if (d != null) {
                this.scroll.setPreferredSize(d);
            }
        }
    }

    private void setKeyMapping(JMenuBar menu, ActionMap actionMap) {
        InputMap im = menu.getInputMap(2);
        ActionMap am = menu.getActionMap();
        Object[] keys = actionMap.keys();
        for (int i = 0; i < keys.length; ++i) {
            Action a = actionMap.get(keys[i]);
            KeyStroke ks = (KeyStroke)a.getValue("AcceleratorKey");
            if (ks == null) continue;
            im.put(ks, keys[i]);
            am.put(keys[i], a);
        }
    }

    private void storePreferences() {
        UserPreferences layoutState = this.resources.getUserLayout();
        layoutState.storePosition("frame.pos", this.getLocation());
        layoutState.storeSize("scroll.size", this.scroll.getSize());
        this.view.storeLayout();
        this.resources.getMruItems().storePreferences();
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowClosing(WindowEvent arg0) {
        this.storePreferences();
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }

    private void registerExitAction(Resources resources) {
        AbstractAsyncAction exitAction = new AbstractAsyncAction(){

            public void doActionPerformed(ActionEvent e) {
                RunnerFrame.this.storePreferences();
                RunnerFrame.this.dispose();
                System.exit(0);
            }
        };
        resources.getResource().configureActionFromResource(exitAction, "EXIT");
        resources.getActionMap().put("EXIT", exitAction);
    }
}

