/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import java.io.File;
import java.util.Date;

public class RunnerEntry {
    public static final int NOT_RUNNED_YET = 0;
    public static final int LAST_RUN_SUSPICOUS = 1;
    public static final int LAST_RUN_PARSEABLE = 2;
    public static final int RUNNING = 3;
    File inFile;
    File lastOutFile;
    String relativePath;
    String runnerOutput;
    Integer right;
    Integer wrong;
    Integer ignored;
    Integer exceptions;
    int status;
    long elapsed;
    transient Boolean mark;
    transient Date lastRunTimestamp;

    public RunnerEntry(File file, String relativePath) {
        this.inFile = file;
        this.relativePath = relativePath;
        this.status = 0;
        this.statusChanged();
        this.mark = Boolean.FALSE;
    }

    public Integer getRight() {
        return this.right;
    }

    public Integer getExceptions() {
        return this.exceptions;
    }

    public File getInFile() {
        return this.inFile;
    }

    public String getRunnerOutput() {
        return this.runnerOutput;
    }

    public int getStatus() {
        return this.status;
    }

    public Integer getWrong() {
        return this.wrong;
    }

    public boolean hasActualResults() {
        return this.status == 2;
    }

    public boolean hasBeenRun() {
        return this.status == 2 || this.status == 1;
    }

    public void setParseableResult(String output, int correct, int wrong, int ignored, int exceptions) {
        this.runnerOutput = output;
        this.status = 2;
        this.statusChanged();
        this.right = new Integer(correct);
        this.wrong = new Integer(wrong);
        this.ignored = new Integer(ignored);
        this.exceptions = new Integer(exceptions);
    }

    public void setUnparseableResult(String output) {
        this.runnerOutput = output;
        this.status = 1;
        this.statusChanged();
    }

    public void setRunning() {
        this.status = 3;
        this.statusChanged();
    }

    public void setQueuedToRun() {
        this.status = 0;
        this.statusChanged();
    }

    private void statusChanged() {
        if (!this.hasActualResults()) {
            this.right = null;
            this.wrong = null;
            this.ignored = null;
            this.exceptions = null;
        }
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof RunnerEntry) {
            RunnerEntry other = (RunnerEntry)o;
            result = this.inFile.equals(other.getInFile());
        }
        return result;
    }

    public int hashCode() {
        return this.inFile.hashCode();
    }

    public String toString() {
        return "RunnerEntry: infile=" + this.inFile.getAbsolutePath() + "\n" + "relativePath=" + this.relativePath + "\n" + "runnerOutput=" + this.runnerOutput + "\n" + "r/w/i/e =" + this.right + " " + this.wrong + " " + this.ignored + " " + this.exceptions + "\n";
    }

    public Integer getIgnored() {
        return this.ignored;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public File getLastOutFile() {
        return this.lastOutFile;
    }

    public void setLastOutFile(File outFile) {
        this.lastOutFile = outFile;
    }

    Object getElapsedString() {
        String result = null;
        if (this.hasActualResults()) {
            long s = this.getElapsed() / 1000L;
            long ms = this.getElapsed() % 1000L / 100L;
            result = String.valueOf(s) + "." + ms;
        }
        return result;
    }

    public Boolean getMark() {
        return this.mark;
    }

    public void setMark(Boolean mark) {
        this.mark = mark;
    }

    public Date getLatRunTimestamp() {
        return this.lastRunTimestamp;
    }

    public void setLastRunTimestamp() {
        this.lastRunTimestamp = new Date();
    }

    public void setLastRunTimestamp(Date latRunTimestamp) {
        this.lastRunTimestamp = latRunTimestamp;
    }
}

