/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.MRUItems;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.UserPreferences;
import javax.swing.ActionMap;
import javax.swing.JFrame;

public class Resources {
    RunnerResourceBundle resource;
    ActionMap actionMap;
    UserPreferences userLayout;
    GlobalLockCoordinator lockCoordinator;
    JFrame applicationFrame;
    MRUItems mruItems;

    public Resources(Configuration configuration, String resourceName, UserPreferences userLayout) {
        this.resource = new RunnerResourceBundle(resourceName);
        this.actionMap = new ActionMap();
        this.lockCoordinator = new GlobalLockCoordinator();
        this.userLayout = userLayout;
        this.setConfiguration(configuration);
        this.mruItems = new MRUItems(this.lockCoordinator, this);
    }

    public void setConfiguration(Configuration c) {
        this.lockCoordinator.setNewConfiguration(c);
    }

    public Configuration getConfiguration() {
        return this.lockCoordinator.getCurrentConfiguration();
    }

    public RunnerResourceBundle getResource() {
        return this.resource;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    public UserPreferences getUserLayout() {
        return this.userLayout;
    }

    public GlobalLockCoordinator getLockCoordinator() {
        return this.lockCoordinator;
    }

    public JFrame getApplicationFrame() {
        return this.applicationFrame;
    }

    public void setApplicationFrame(JFrame applicationFrame) {
        this.applicationFrame = applicationFrame;
    }

    public MRUItems getMruItems() {
        return this.mruItems;
    }
}

