/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.ConfigurationStorage;
import fit.guirunner.DirectoryItem;
import fit.guirunner.EnvironmentContext;
import fit.guirunner.Resources;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.logic.DirectoryFilter;
import fit.guirunner.logic.FileFind;
import fit.guirunner.logic.SimpleWildcardFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class NewTestfileDialog
extends JDialog {
    public static final String KEY_NEWTESTFILE = "label.NewTestfile";
    public static final String KEY_DIRECTORY = "label.Diretory";
    public static final String KEY_NEW_DIRECTORY = "label.newDirecotry";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_CREATE = "create";
    public static final String KEY_FILENAME_MISSING = "text.FilenameMissing";
    public static final String KEY_INVALID_FILENAME = "text.InvalidFilename";
    public static final String KEY_FILE_ALREADY_EXISTS = "text.FileAlreadyExists";
    public static final String KEY_BASE_DIRECTORY = "label.BaseDirectory";
    public static final String KEY_TOOLTIP_CREATE_NEW_DIRECTORY = "tooltip.createNewDirectory";
    public static final String KEY_TITLE_CREATE_NEW_DIRECTORY = "title.createNewDirectory";
    Resources resources;
    RunnerResourceBundle resource;
    JTextField newFilename;
    JComboBox directories;
    JButton newDirectory;
    JButton cancel;
    JButton create;
    String dialogTitle;
    JLabel statusMessage;
    EnvironmentContext environmentContext;
    FilenameFilter filenameValidator;
    File selectedNewFile;

    public NewTestfileDialog(Resources resources, EnvironmentContext environmentContext, FilenameFilter filenameValidator, String title) {
        super(resources.getApplicationFrame(), title, true);
        this.resources = resources;
        this.resource = resources.getResource();
        this.environmentContext = environmentContext;
        this.filenameValidator = filenameValidator;
        this.selectedNewFile = null;
        this.init();
        this.updateDirectories();
        this.init_layout();
    }

    private File creaSelectedFile() {
        DirectoryItem di = (DirectoryItem)this.directories.getSelectedItem();
        File result = null;
        if (di != null) {
            result = new File(di.getTheDirectory(), this.newFilename.getText());
        }
        return result;
    }

    private boolean validateInput() {
        boolean valid = false;
        String text = this.newFilename.getText();
        String msg = null;
        if ("".equals(text)) {
            msg = KEY_FILENAME_MISSING;
        } else if (!this.filenameValidator.accept(null, text)) {
            msg = KEY_INVALID_FILENAME;
        } else {
            File newFile = this.creaSelectedFile();
            if (this.creaSelectedFile().exists()) {
                msg = KEY_FILE_ALREADY_EXISTS;
            } else {
                valid = true;
                this.selectedNewFile = newFile;
            }
        }
        this.statusMessage.setText(msg != null ? this.resource.getResourceString(msg) : "");
        return valid;
    }

    private void updateDirectories() {
        this.directories.removeAllItems();
        DirectoryItem di = new DirectoryItem(this.resource.getResourceString(KEY_BASE_DIRECTORY), this.environmentContext.getInDir());
        this.directories.addItem(di);
        FileFind ff = new FileFind(new DirectoryFilter());
        List dirs = ff.execute(this.environmentContext.getInDir());
        int offset = this.environmentContext.getInDir().getAbsolutePath().length() + 1;
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            File dir = (File)i.next();
            String relativeName = dir.getAbsolutePath().substring(offset);
            this.directories.addItem(new DirectoryItem(relativeName, dir));
        }
    }

    protected void init() {
        this.newFilename = new JTextField(40);
        this.directories = new JComboBox();
        this.directories.setPrototypeDisplayValue("a dummy text for a directory");
        this.directories.setEnabled(true);
        this.newDirectory = new JButton(this.resource.getResourceString(KEY_NEW_DIRECTORY));
        this.newDirectory.setToolTipText(this.resource.getResourceString(KEY_TOOLTIP_CREATE_NEW_DIRECTORY));
        this.cancel = new JButton(this.resource.getResourceString(KEY_CANCEL));
        this.create = new JButton(this.resource.getResourceString(KEY_CREATE));
        this.getRootPane().setDefaultButton(this.create);
        this.statusMessage = new JLabel();
        this.statusMessage.setForeground(Color.RED);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                NewTestfileDialog.this.selectedNewFile = null;
                NewTestfileDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        KeyStroke escKey = KeyStroke.getKeyStroke("ESCAPE");
        InputMap im = this.getRootPane().getInputMap(2);
        im.put(escKey, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", cancelAction);
        this.create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (NewTestfileDialog.this.validateInput()) {
                    NewTestfileDialog.this.dispose();
                }
            }
        });
        this.newDirectory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NewTestfileDialog.this.createNewDirFileChooser();
            }
        });
    }

    protected JLabel label(String key) {
        return new JLabel(this.resource.getResourceString(key));
    }

    protected void init_layout() {
        Container hlp2 = this.getContentPane();
        hlp2.setLayout(new BorderLayout());
        JPanel cp = new JPanel(new GridBagLayout());
        hlp2.add((Component)cp, "North");
        GridBagConstraints label = new GridBagConstraints();
        GridBagConstraints fields = new GridBagConstraints();
        GridBagConstraints buttons = new GridBagConstraints();
        GridBagConstraints status = new GridBagConstraints();
        label.insets = new Insets(2, 8, 2, 4);
        label.gridwidth = -1;
        label.weightx = 1.0;
        label.anchor = 13;
        label.gridx = 0;
        GridBagConstraints label1 = (GridBagConstraints)label.clone();
        label1.insets = new Insets(8, 8, 2, 4);
        GridBagConstraints labelAbove = (GridBagConstraints)label.clone();
        labelAbove.gridwidth = 0;
        labelAbove.anchor = 17;
        fields.insets = new Insets(2, 2, 2, 4);
        fields.gridwidth = 0;
        fields.weightx = 4.0;
        fields.anchor = 17;
        fields.gridx = -1;
        GridBagConstraints fields1 = (GridBagConstraints)fields.clone();
        fields1.insets = new Insets(8, 2, 2, 4);
        status.insets = new Insets(8, 4, 4, 4);
        status.weightx = 10.0;
        status.anchor = 17;
        status.gridwidth = -1;
        buttons.insets = new Insets(8, 4, 4, 4);
        buttons.anchor = 26;
        buttons.weightx = 0.0;
        cp.add((Component)this.label(KEY_NEWTESTFILE), label1);
        cp.add((Component)this.newFilename, fields1);
        cp.add((Component)this.label(KEY_DIRECTORY), label);
        cp.add((Component)this.directories, fields1);
        cp.add((Component)new JLabel(), label);
        cp.add((Component)this.newDirectory, fields);
        JPanel hlp = new JPanel(new FlowLayout(0));
        hlp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        hlp.add(this.statusMessage);
        hlp2.add((Component)hlp, "Center");
        hlp = new JPanel(new FlowLayout(4));
        hlp.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        hlp.add(this.create);
        hlp.add(this.cancel);
        hlp2.add((Component)hlp, "East");
    }

    public File getSelectedNewFile() {
        return this.selectedNewFile;
    }

    private void createNewDirFileChooser() {
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(this.resource.getResourceString(KEY_TITLE_CREATE_NEW_DIRECTORY));
        fd.setFileSelectionMode(1);
        fd.setCurrentDirectory(this.environmentContext.getInDir());
        int result = fd.showOpenDialog(SwingUtilities.getRoot(this.resources.getApplicationFrame()));
        if (result == 0) {
            this.updateDirectories();
            File choosen = fd.getSelectedFile();
            this.setSelectedDir(choosen);
        }
    }

    private void setSelectedDir(File choosen) {
        for (int i = 0; i < this.directories.getItemCount(); ++i) {
            if (!choosen.equals(((DirectoryItem)this.directories.getItemAt(i)).getTheDirectory())) continue;
            this.directories.setSelectedIndex(i);
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        Resources resources = new Resources(null, "fit.guirunner.resource.GuiRunner", null);
        Configuration c = new Configuration();
        File development = new File("c:/temp/Fit.GuiRunner.Config");
        try {
            c = ConfigurationStorage.load(development);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        c.setConfigurationName(development);
        SimpleWildcardFilter filenameValidator = new SimpleWildcardFilter(c.getPattern());
        EnvironmentContext environmentContext = new EnvironmentContext(c);
        final NewTestfileDialog dlg = new NewTestfileDialog(resources, environmentContext, filenameValidator, "Test");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dlg.pack();
                dlg.setVisible(true);
            }
        });
    }

    public void setCurrentFile(File inFile) {
        this.setSelectedDir(inFile.getParentFile());
        this.newFilename.setText(inFile.getName());
    }
}

