/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.ConfigurationStorage;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.Resources;
import fit.guirunner.UserPreferences;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;

public class MRUItems
implements PropertyChangeListener {
    private static final int MRU_MAX_SIZE = 5;
    private JSeparator separatorBefore;
    private JMenuItem[] items;
    Resources resources;
    GlobalLockCoordinator lockCoordinator;
    private LinkedList mruConfigurations;

    public MRUItems(GlobalLockCoordinator lockCoordinator, Resources resources) {
        this.lockCoordinator = lockCoordinator;
        this.resources = resources;
        this.mruConfigurations = new LinkedList();
        this.items = null;
        this.loadPreferences();
        lockCoordinator.addPropertyChangeListener(this);
    }

    public int getMRUItemsSize() {
        return 5;
    }

    private void firstMruEntry(File f) {
        if (f != null) {
            this.mruConfigurations.addFirst(f);
        }
    }

    public void storePreferences() {
        Properties properties = new Properties();
        LinkedList<String> deleteList = new LinkedList<String>();
        int currentSize = this.mruConfigurations.size();
        for (int i = 0; i < 5; ++i) {
            boolean enabled = i < currentSize;
            String key = "mru." + String.valueOf(i);
            if (enabled) {
                properties.put(key, ((File)this.mruConfigurations.get(i)).getAbsolutePath());
                continue;
            }
            deleteList.add(key);
        }
        this.resources.getUserLayout().updateProperties(properties, deleteList);
    }

    public void loadPreferences() {
        UserPreferences preferences = this.resources.getUserLayout();
        this.mruConfigurations.clear();
        for (int i = 0; i < 5; ++i) {
            String key = "mru." + String.valueOf(i);
            String value = preferences.getProperty(key);
            if (value == null) continue;
            this.mruConfigurations.add(new File(value));
        }
    }

    private void lazyInit() {
        if (this.items == null) {
            this.initItems();
            this.updateItems();
        }
    }

    private void initItems() {
        this.separatorBefore = new JSeparator();
        this.items = new JMenuItem[5];
        for (int i = 0; i < 5; ++i) {
            this.items[i] = new JMenuItem();
            this.items[i].setAction(new ItemAction(i + 1));
            this.items[i].setMnemonic(49 + i);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("hasConfiguration".equals(evt.getPropertyName())) {
            File newF;
            Configuration oldConf = (Configuration)evt.getOldValue();
            Configuration newConf = (Configuration)evt.getNewValue();
            File oldF = oldConf != null ? oldConf.getConfigurationFile() : null;
            File file = newF = newConf != null ? newConf.getConfigurationFile() : null;
            if (oldF == null || newF == null || !oldF.equals(newF)) {
                this.mruConfigurations.remove(oldF);
                this.mruConfigurations.remove(newF);
                this.firstMruEntry(oldF);
                this.firstMruEntry(newF);
                this.dropOldEntries();
                if (this.items != null) {
                    this.updateItems();
                }
            }
        } else if (this.items != null) {
            boolean mruItemsEnabled = this.lockCoordinator.canReadFilesystem();
            this.updateEnabledStatus(mruItemsEnabled);
        }
    }

    private void updateEnabledStatus(boolean mruItemsEnabled) {
        for (int i = 0; i < 5; ++i) {
            if (!this.items[i].isVisible()) continue;
            this.items[i].getAction().setEnabled(mruItemsEnabled);
        }
    }

    private void dropOldEntries() {
        while (this.mruConfigurations.size() > 6) {
            this.mruConfigurations.remove(6);
        }
    }

    private void updateItems() {
        int currentSize = this.mruConfigurations.size();
        this.separatorBefore.setVisible(currentSize > 1);
        for (int i = 0; i < 5; ++i) {
            int listIdx = i + 1;
            boolean enabled = listIdx < currentSize;
            this.items[i].setVisible(enabled);
            this.items[i].getAction().setEnabled(enabled);
            if (!enabled) continue;
            String newText = String.valueOf(listIdx) + " " + ((File)this.mruConfigurations.get(listIdx)).getAbsolutePath();
            this.items[i].setText(newText);
        }
    }

    public JSeparator getSeparatorBefore() {
        this.lazyInit();
        return this.separatorBefore;
    }

    public JMenuItem getMRUItem(int idx) {
        this.lazyInit();
        return this.items[idx];
    }

    class ItemAction
    extends AbstractAction {
        int index;

        ItemAction(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            File newConfiguration = (File)MRUItems.this.mruConfigurations.get(this.index);
            ConfigurationStorage.setCurrentConfiguration(MRUItems.this.resources, newConfiguration);
        }
    }
}

