/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.GuiRunnerActions;
import fit.guirunner.Resources;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.SortedTableModel;
import fit.guirunner.UserPreferences;
import fit.guirunner.actions.AbstractAsyncAction;
import fit.guirunner.actions.DeleteTestfileAction;
import fit.guirunner.actions.EditInputFileAction;
import fit.guirunner.actions.MoveOrRenameTestAction;
import fit.guirunner.actions.NewTestAction;
import fit.guirunner.actions.OpenOutputFileAction;
import fit.guirunner.actions.ResortViewAction;
import fit.guirunner.actions.ResultsToClipboardAction;
import fit.guirunner.actions.RunAllAction;
import fit.guirunner.actions.RunCurrentAction;
import fit.guirunner.actions.RunMarkedAction;
import fit.guirunner.actions.ShowRunnerOutputAction;
import fit.guirunner.actions.StopTestsAction;
import fit.guirunner.actions.TerminateTestsAction;
import fit.guirunner.swing.ColoredIntegerCellRenderer;
import fit.guirunner.swing.ExtraBorderCellRenderer;
import fit.guirunner.swing.TableSortCoordinator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GuiRunnerView
extends JTable
implements GuiRunnerActions,
MouseListener {
    JPopupMenu popupMenu;
    ActionMap actionMap;
    ActionEvent dummyActionEvent;
    UserPreferences layoutState;
    static /* synthetic */ Class class$java$lang$String;

    public GuiRunnerView(RunnerTableModel model, Resources resources) {
        SortedTableModel stm = new SortedTableModel(resources.getLockCoordinator(), model);
        this.setModel(stm);
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setIdentifier(new Integer(i));
        }
        this.addMouseListener(this);
        this.layoutState = resources.getUserLayout();
        RunnerResourceBundle resource = resources.getResource();
        GlobalLockCoordinator lockCoordinator = resources.getLockCoordinator();
        this.actionMap = resources.getActionMap();
        AbstractAsyncAction action = new RunCurrentAction(this, resources.getLockCoordinator(), resources, model);
        resource.configureActionFromResource(action, "RUN_CURRENT");
        this.actionMap.put("RUN_CURRENT", action);
        action = new RunMarkedAction(this, resources.getLockCoordinator(), resources, model);
        resource.configureActionFromResource(action, "RUN_MARKED");
        this.actionMap.put("RUN_MARKED", action);
        action = new RunAllAction(this, resources.getLockCoordinator(), resources, model);
        resources.getResource().configureActionFromResource(action, "RUN_ALL");
        this.actionMap.put("RUN_ALL", action);
        action = new StopTestsAction(resources.getLockCoordinator());
        resources.getResource().configureActionFromResource(action, "STOP_TESTS");
        this.actionMap.put("STOP_TESTS", action);
        action = new TerminateTestsAction(resources.getLockCoordinator());
        resources.getResource().configureActionFromResource(action, "TERMINATE_TESTS");
        this.actionMap.put("TERMINATE_TESTS", action);
        action = new DeleteTestfileAction(this, resources.getLockCoordinator(), resources, model);
        resources.getResource().configureActionFromResource(action, "DELETE_TEST");
        this.actionMap.put("DELETE_TEST", action);
        action = new NewTestAction(resources.getLockCoordinator(), resources, model);
        resources.getResource().configureActionFromResource(action, "NEW_TEST");
        this.actionMap.put("NEW_TEST", action);
        action = new MoveOrRenameTestAction(this, resources.getLockCoordinator(), resources, model);
        resources.getResource().configureActionFromResource(action, "MOVE_TEST");
        this.actionMap.put("MOVE_TEST", action);
        action = new OpenOutputFileAction(this, lockCoordinator, resources);
        resource.configureActionFromResource(action, "OPEN_OUTPUTFILE");
        this.actionMap.put("OPEN_OUTPUTFILE", action);
        action = new EditInputFileAction(this, lockCoordinator, resources);
        resource.configureActionFromResource(action, "EDIT_INPUTFILE");
        this.actionMap.put("EDIT_INPUTFILE", action);
        action = new ShowRunnerOutputAction(this, lockCoordinator);
        resource.configureActionFromResource(action, "SHOW_RUNNER_OUTPUT");
        this.actionMap.put("SHOW_RUNNER_OUTPUT", action);
        action = new ResortViewAction(lockCoordinator, stm);
        resource.configureActionFromResource(action, "RESORT_VIEW");
        this.actionMap.put("RESORT_VIEW", action);
        action = new ResultsToClipboardAction(lockCoordinator, this);
        resource.configureActionFromResource(action, "COPY_RESULTS");
        this.actionMap.put("COPY_RESULTS", action);
        this.popupMenu = this.kontextMenu(this.actionMap);
        this.dummyActionEvent = new ActionEvent(this, 0, "");
        this.getColumn(new Integer(8)).setCellRenderer(new ExtraBorderCellRenderer(4));
        this.getColumn(new Integer(9)).setCellRenderer(new ExtraBorderCellRenderer(4));
        this.getColumn(new Integer(6)).setCellRenderer(new ExtraBorderCellRenderer(4));
        this.getColumn(new Integer(2)).setCellRenderer(new ExtraBorderCellRenderer());
        this.getColumn(new Integer(1)).setCellRenderer(new ExtraBorderCellRenderer());
        this.getColumn(new Integer(4)).setCellRenderer(new ColoredIntegerCellRenderer(Color.GREEN));
        this.getColumn(new Integer(5)).setCellRenderer(new ColoredIntegerCellRenderer(Color.RED));
        this.getColumn(new Integer(7)).setCellRenderer(new ColoredIntegerCellRenderer(Color.YELLOW));
        TableSortCoordinator tableSortCoordinator = new TableSortCoordinator(this);
        this.getTableHeader().addMouseListener(tableSortCoordinator);
        tableSortCoordinator.addPropertyChangeListener(stm);
        this.getSelectionModel().setSelectionMode(0);
        if (!this.loadLayout()) {
            this.initialLayout();
        }
    }

    protected JPopupMenu kontextMenu(ActionMap am) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(am.get("RUN_CURRENT"));
        menu.add(am.get("RUN_MARKED"));
        menu.add(am.get("RUN_ALL"));
        menu.addSeparator();
        menu.add(am.get("COPY_RESULTS"));
        menu.addSeparator();
        menu.add(am.get("OPEN_OUTPUTFILE"));
        menu.add(am.get("EDIT_INPUTFILE"));
        menu.add(am.get("SHOW_RUNNER_OUTPUT"));
        menu.addSeparator();
        menu.add(am.get("NEW_TEST"));
        menu.add(am.get("MOVE_TEST"));
        menu.add(am.get("DELETE_TEST"));
        return menu;
    }

    public void storeLayout() {
        StringBuffer pers = new StringBuffer();
        String sep = "";
        TableColumnModel cm = this.getColumnModel();
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            int viewIdx = this.convertColumnIndexToView(i);
            int viewWidth = cm.getColumn(viewIdx).getWidth();
            pers.append(sep);
            pers.append(i).append(",");
            pers.append(viewIdx).append(",");
            pers.append(viewWidth);
            sep = ",";
        }
        this.layoutState.storeProperty("table.columns", pers.toString());
        this.layoutState.storeSize("table.size", this.getSize());
    }

    public void initialLayout() {
        TableColumnModel cm = this.getColumnModel();
        int factor = 1;
        int sumWidth = 0;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            switch (i) {
                case 2: {
                    factor = 5;
                    break;
                }
                case 1: {
                    factor = 2;
                    break;
                }
                default: {
                    factor = 1;
                }
            }
            sumWidth += this.setDefaultColumnWidth(cm, i, factor);
        }
        this.setSize(new Dimension(sumWidth, sumWidth / 3));
    }

    public boolean loadLayout() {
        String[] hlp;
        boolean loaded = false;
        String pers = this.layoutState.getProperty("table.columns");
        TableColumnModel cm = this.getColumnModel();
        TableColumn[] viewToModel = new TableColumn[cm.getColumnCount()];
        if (pers != null && (hlp = pers.split(",")) != null && hlp.length % 3 == 0 && hlp.length / 3 == cm.getColumnCount()) {
            int i = 0;
            while (i < hlp.length) {
                int idxModel = Integer.parseInt(hlp[i++]);
                int idxView = Integer.parseInt(hlp[i++]);
                int widthView = Integer.parseInt(hlp[i++]);
                cm.getColumn(idxModel).setPreferredWidth(widthView);
                viewToModel[idxView] = cm.getColumn(idxModel);
            }
            for (i = 0; i < viewToModel.length; ++i) {
                cm.removeColumn(viewToModel[i]);
            }
            for (i = 0; i < viewToModel.length; ++i) {
                cm.addColumn(viewToModel[i]);
            }
            Dimension d = this.layoutState.loadSize("table.size");
            if (d != null) {
                this.setSize(d);
            }
            loaded = true;
        }
        return loaded;
    }

    private int setDefaultColumnWidth(TableColumnModel cm, int i, int factor) {
        int w = this.getDefaultRenderer(GuiRunnerView.class$java$lang$String == null ? (GuiRunnerView.class$java$lang$String = GuiRunnerView.class$((String)"java.lang.String")) : GuiRunnerView.class$java$lang$String).getTableCellRendererComponent((JTable)this, (Object)this.getColumnName((int)i), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width;
        w = w * factor * 14 / 10;
        cm.getColumn(i).setPreferredWidth(w);
        return w;
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int r = this.rowAtPoint(e.getPoint());
            this.getSelectionModel().setSelectionInterval(r, r);
            if (this.getCellEditor() != null) {
                this.getCellEditor().cancelCellEditing();
            }
            this.popupMenu.show(this, e.getX(), e.getY());
        } else if (e.getClickCount() == 2) {
            int c = this.columnAtPoint(e.getPoint());
            c = this.convertColumnIndexToModel(c);
            switch (c) {
                case 3: {
                    this.actionMap.get("SHOW_RUNNER_OUTPUT").actionPerformed(this.dummyActionEvent);
                    break;
                }
                case 2: {
                    this.actionMap.get("EDIT_INPUTFILE").actionPerformed(this.dummyActionEvent);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    this.actionMap.get("OPEN_OUTPUTFILE").actionPerformed(this.dummyActionEvent);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent arg0) {
    }

    public void mouseExited(MouseEvent arg0) {
    }

    public void mousePressed(MouseEvent arg0) {
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

