/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.logic.FileFind;
import fit.guirunner.logic.VariableExpansion;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class EnvironmentContext {
    String runnerCmd;
    String runnerWorkingDirPattern;
    String openCmd;
    String editCmd;
    File inDir;
    File outDir;
    File libDir;
    File runnerWorkingDir;

    public EnvironmentContext(Configuration config) throws IOException {
        File configDir = config.getConfigurationDir();
        this.inDir = EnvironmentContext.makeAbs(configDir, config.getInDir());
        this.outDir = EnvironmentContext.makeAbs(configDir, config.getOutDir());
        this.libDir = EnvironmentContext.makeAbs(configDir, config.getLibDir());
        VariableExpansion strrep = this.defaultExpansion(config);
        this.runnerCmd = strrep.replace(config.getRunnerCommand());
        this.openCmd = strrep.replace(config.getOpenCommand());
        this.editCmd = strrep.replace(config.getEditCommand());
        String wd = config.getRunnerWorkingDir();
        if (wd != null && !"".equals(wd)) {
            if (wd.indexOf(123) >= 0 && wd.indexOf(125) >= 0 && wd.indexOf(36) >= 0) {
                this.runnerWorkingDirPattern = wd;
            } else {
                this.runnerWorkingDir = EnvironmentContext.makeAbs(configDir, wd);
            }
        }
    }

    protected static File makeAbs(File parent, String afile) throws IOException {
        File hlp = new File(afile);
        if (!hlp.isAbsolute() && parent != null) {
            hlp = new File(parent, afile);
        }
        return hlp.getCanonicalFile();
    }

    public VariableExpansion defaultExpansion(Configuration config) throws IOException {
        HashMap<String, String> repl = new HashMap<String, String>();
        repl.put("indir", this.inDir.getAbsolutePath());
        repl.put("outdir", this.outDir.getAbsolutePath());
        repl.put("libdir", this.libDir.getAbsolutePath());
        String cp = EnvironmentContext.generateClasspath(config.getConfigurationDir(), config.getLibDir());
        repl.put("classpath", cp);
        return new VariableExpansion(repl);
    }

    public static String generateClasspath(File parent, String libDir) throws IOException {
        File libdir = EnvironmentContext.makeAbs(parent, libDir);
        FileFind ff = new FileFind("*.jar");
        Iterator i = ff.execute(libdir).iterator();
        StringBuffer result = new StringBuffer();
        String separator = System.getProperty("path.separator");
        String hlp = "";
        while (i.hasNext()) {
            result.append(hlp);
            result.append(((File)i.next()).getAbsoluteFile());
            hlp = separator;
        }
        return result.toString();
    }

    public static void createMissingDirectories(File afile) {
        File parentDir = afile.getParentFile();
        if (!parentDir.isDirectory()) {
            parentDir.mkdirs();
        }
    }

    public String getRunnerCmd() {
        return this.runnerCmd;
    }

    public File getInDir() {
        return this.inDir;
    }

    public File getLibDir() {
        return this.libDir;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public String getEditCmd() {
        return this.editCmd;
    }

    public String getOpenCmd() {
        return this.openCmd;
    }

    public String getWorkDirPattern() {
        return this.runnerWorkingDirPattern;
    }

    public File getWorkingDir() {
        return this.runnerWorkingDir;
    }
}

