/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.Resources;
import fit.guirunner.RunnerResourceBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class EditConfigurationDialog
extends JDialog {
    public static final String KEY_INDIR = "label.indir";
    public static final String KEY_OUTDIR = "label.outdir";
    public static final String KEY_LIBDIR = "label.libdir";
    public static final String KEY_PATTERN = "label.pattern";
    public static final String KEY_RUNNER_COMMAND = "label.runner.command";
    public static final String KEY_OPEN_COMMAND = "label.open.command";
    public static final String KEY_EDIT_COMMAND = "label.edit.command";
    public static final String KEY_CANCEL = "cancel";
    public static final String KEY_APPLY = "apply";
    public static final String KEY_TITLE = "title.EditConfiguration";
    public static final String KEY_RUNNER_WORKING_DIR = "label.runner.workingDir";
    public static final String TOOLTIP_INDIR = "tooltip.indir";
    public static final String TOOLTIP_OUTDIR = "tooltip.outdir";
    public static final String TOOLTIP_LIBDIR = "tooltip.libdir";
    public static final String TOOLTIP_RUNNER_WORKING_DIR = "tooltip.runner.workingDir";
    RunnerResourceBundle resource;
    Configuration configuration;
    JTextField inDir;
    JTextField outDir;
    JTextField libDir;
    JTextField pattern;
    JTextField runnerCommand;
    JTextField openCommand;
    JTextField editCommand;
    JTextField runnerWorkingDir;
    JButton cancel;
    JButton apply;
    String dialogTitle;

    public EditConfigurationDialog(Resources resources, Configuration config) {
        super(resources.getApplicationFrame(), "", true);
        this.resource = resources.getResource();
        this.configuration = null;
        this.dialogTitle = this.resource.getResourceString(KEY_TITLE);
        this.setTitle(null);
        this.init();
        this.config2fields(config);
        this.init_layout();
    }

    private Configuration fields2config() {
        return new Configuration(this.inDir.getText(), this.outDir.getText(), this.libDir.getText(), this.pattern.getText(), this.runnerCommand.getText(), this.openCommand.getText(), this.editCommand.getText(), this.runnerWorkingDir.getText());
    }

    private void config2fields(Configuration configuration) {
        this.inDir.setText(configuration.getInDir());
        this.outDir.setText(configuration.getOutDir());
        this.libDir.setText(configuration.getLibDir());
        this.pattern.setText(configuration.getPattern());
        this.runnerCommand.setText(configuration.getRunnerCommand());
        this.openCommand.setText(configuration.getOpenCommand());
        this.editCommand.setText(configuration.getEditCommand());
        this.runnerWorkingDir.setText(configuration.getRunnerWorkingDir());
    }

    protected void init() {
        this.inDir = new JTextField(40);
        this.outDir = new JTextField(40);
        this.libDir = new JTextField(40);
        this.runnerWorkingDir = new JTextField(40);
        this.inDir.setToolTipText(this.resource.getResourceString(TOOLTIP_INDIR));
        this.outDir.setToolTipText(this.resource.getResourceString(TOOLTIP_OUTDIR));
        this.libDir.setToolTipText(this.resource.getResourceString(TOOLTIP_LIBDIR));
        this.runnerWorkingDir.setToolTipText(this.resource.getResourceString(TOOLTIP_RUNNER_WORKING_DIR));
        this.pattern = new JTextField(10);
        this.runnerCommand = new JTextField(80);
        this.openCommand = new JTextField(80);
        this.editCommand = new JTextField(80);
        this.cancel = new JButton(this.resource.getResourceString(KEY_CANCEL));
        this.apply = new JButton(this.resource.getResourceString(KEY_APPLY));
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.apply);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                EditConfigurationDialog.this.configuration = null;
                EditConfigurationDialog.this.dispose();
            }
        };
        this.cancel.addActionListener(cancelAction);
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                EditConfigurationDialog.this.configuration = EditConfigurationDialog.this.fields2config();
                EditConfigurationDialog.this.dispose();
            }
        });
        KeyStroke escKey = KeyStroke.getKeyStroke("ESCAPE");
        InputMap im = this.getRootPane().getInputMap(2);
        im.put(escKey, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", cancelAction);
    }

    protected JLabel label(String key) {
        return new JLabel(this.resource.getResourceString(key));
    }

    protected void init_layout() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints label = new GridBagConstraints();
        GridBagConstraints fields = new GridBagConstraints();
        GridBagConstraints buttons = new GridBagConstraints();
        label.insets = new Insets(2, 8, 2, 4);
        label.gridwidth = -1;
        label.weightx = 1.0;
        label.anchor = 13;
        label.gridx = 0;
        GridBagConstraints label1 = (GridBagConstraints)label.clone();
        label1.insets = new Insets(8, 8, 2, 4);
        GridBagConstraints labelAbove = (GridBagConstraints)label.clone();
        labelAbove.gridwidth = 0;
        labelAbove.anchor = 17;
        fields.insets = new Insets(2, 2, 2, 4);
        fields.gridwidth = 0;
        fields.weightx = 1.0;
        fields.anchor = 17;
        fields.gridx = -1;
        GridBagConstraints fields1 = (GridBagConstraints)fields.clone();
        fields1.insets = new Insets(8, 2, 2, 4);
        buttons.insets = new Insets(8, 4, 4, 4);
        buttons.anchor = 26;
        buttons.gridwidth = 0;
        cp.add((Component)this.label(KEY_INDIR), label1);
        cp.add((Component)this.inDir, fields1);
        cp.add((Component)this.label(KEY_OUTDIR), label);
        cp.add((Component)this.outDir, fields);
        cp.add((Component)this.label(KEY_LIBDIR), label);
        cp.add((Component)this.libDir, fields);
        cp.add((Component)this.label(KEY_RUNNER_WORKING_DIR), label);
        cp.add((Component)this.runnerWorkingDir, fields);
        cp.add((Component)this.label(KEY_PATTERN), label);
        cp.add((Component)this.pattern, fields);
        cp.add((Component)this.label(KEY_RUNNER_COMMAND), label);
        cp.add((Component)this.runnerCommand, fields);
        cp.add((Component)this.label(KEY_OPEN_COMMAND), label);
        cp.add((Component)this.openCommand, fields);
        cp.add((Component)this.label(KEY_EDIT_COMMAND), label);
        cp.add((Component)this.editCommand, fields);
        JPanel hlp = new JPanel();
        hlp.setLayout(new FlowLayout(4, 0, 0));
        hlp.add(this.apply);
        hlp.add(this.cancel);
        cp.add((Component)hlp, buttons);
    }

    public static void main(String[] args) {
        Resources resources = new Resources(null, "fit.guirunner.resource.GuiRunner", null);
        final EditConfigurationDialog dlg = new EditConfigurationDialog(resources, new Configuration());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dlg.pack();
                dlg.setVisible(true);
                if (dlg.getConfiguration() != null) {
                    System.out.println("Approved: " + String.valueOf(dlg.getConfiguration()));
                }
            }
        });
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    public void setTitle(String name) {
        String newTitle = this.dialogTitle;
        if (name != null) {
            newTitle = newTitle + " - " + name;
        }
        super.setTitle(newTitle);
    }
}

