/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import fit.guirunner.Configuration;
import fit.guirunner.EditConfigurationDialog;
import fit.guirunner.GlobalLockCoordinator;
import fit.guirunner.GuiRunnerActions;
import fit.guirunner.Resources;
import fit.guirunner.RunnerResourceBundle;
import fit.guirunner.actions.AbstractAsyncAction;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

public class ConfigurationStorage
implements GuiRunnerActions {
    public static final int MAX_MRU_ENTRIES = 5;
    public static final String KEY_INDIR = "indir";
    public static final String KEY_OUTDIR = "outdir";
    public static final String KEY_LIBDIR = "libdir";
    public static final String KEY_CMD_RUNNER = "command.runner";
    public static final String KEY_CMD_OPEN = "command.open";
    public static final String KEY_CMD_EDIT = "command.edit";
    public static final String KEY_PATTERN = "pattern";
    public static final String KEY_RUNNER_WD = "runner.workingDir";
    private static final int CMD_NEW = 1;
    private static final int CMD_EXISTING = 2;
    public static final String KEY_FILEDIALOG_EXISTING = "text.filedialog.existing";
    public static final String KEY_FILEDIALOG_NEW = "text.filedialog.new";
    public static final String KEY_OPTION_NEW = "text.option.new";
    public static final String KEY_OPTION_EXISTING = "text.option.existiong";
    public static final String KEY_OPTION_CANCEL = "text.option.cancel";
    public static final String KEY_OPTION_TITLE = "text.option.title";
    public static final String KEY_OPTION_MESSAGE = "text.option.message";
    Resources resources;

    public ConfigurationStorage(Resources resources) {
        this.resources = resources;
    }

    public void setCurrentConfiguration(String filename) {
        if (filename != null) {
            this.setCurrentConfiguration(new File(filename));
        }
    }

    public void setCurrentConfiguration(File configFile) {
        ConfigurationStorage.setCurrentConfiguration(this.resources, configFile);
    }

    public static void setCurrentConfiguration(Resources resources, File configFile) {
        Configuration c = null;
        try {
            c = ConfigurationStorage.load(configFile);
            c.setConfigurationName(configFile);
            resources.getUserLayout().storeProperty("ConfigurationStorage.currentConfiguration", configFile.getAbsolutePath());
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        resources.setConfiguration(c);
    }

    public AbstractAsyncAction getOpenConfigurationAction(String resourceKey) {
        OpenConfigurationAction openConfigAction = new OpenConfigurationAction(2, this.resources.getLockCoordinator());
        this.resources.getResource().configureActionFromResource(openConfigAction, resourceKey);
        return openConfigAction;
    }

    public AbstractAsyncAction getNewConfigurationAction(String resourceKey) {
        OpenConfigurationAction newConfigAction = new OpenConfigurationAction(1, this.resources.getLockCoordinator());
        this.resources.getResource().configureActionFromResource(newConfigAction, resourceKey);
        return newConfigAction;
    }

    public AbstractAsyncAction getEditConfigurationAction(String resourceKey) {
        AbstractAsyncAction a = new AbstractAsyncAction(){

            public void doActionPerformed(ActionEvent e) {
                Configuration config = ConfigurationStorage.this.resources.getConfiguration();
                File configFile = config.getConfigurationFile();
                EditConfigurationDialog dlg = new EditConfigurationDialog(ConfigurationStorage.this.resources, config);
                dlg.setTitle(configFile.getAbsolutePath());
                dlg.pack();
                dlg.setLocationRelativeTo(ConfigurationStorage.this.resources.getApplicationFrame());
                dlg.setVisible(true);
                if (dlg.getConfiguration() != null) {
                    try {
                        Configuration newConfig = dlg.getConfiguration();
                        ConfigurationStorage.save(newConfig, configFile);
                        newConfig.setConfigurationName(configFile);
                        ConfigurationStorage.this.resources.setConfiguration(newConfig);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }

            protected boolean isActionEnabled() {
                return this.getLockCoordinator().canEditConfiguration();
            }
        };
        this.resources.getResource().configureActionFromResource(a, resourceKey);
        return a;
    }

    protected File showOpenDialog(int a) {
        int result;
        final int action = a;
        File choosen = null;
        File configDir = null;
        if (this.resources.getConfiguration() != null) {
            configDir = this.resources.getConfiguration().getConfigurationDir();
        }
        RunnerResourceBundle resource = this.resources.getResource();
        JFileChooser fd = new JFileChooser(){

            public void approveSelection() {
                File selectedFile = this.getSelectedFile();
                if (selectedFile != null && (action == 1 && !selectedFile.exists() || action == 2 && selectedFile.isFile())) {
                    super.approveSelection();
                }
            }
        };
        fd.setDialogTitle(resource.getResourceString(action == 1 ? KEY_FILEDIALOG_NEW : KEY_FILEDIALOG_EXISTING));
        fd.setFileSelectionMode(0);
        if (configDir != null) {
            fd.setCurrentDirectory(configDir);
        }
        if ((result = fd.showOpenDialog(SwingUtilities.getRoot(this.resources.getApplicationFrame()))) == 0) {
            choosen = fd.getSelectedFile().getAbsoluteFile();
        }
        return choosen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration load(File configfile) throws IOException {
        Configuration c = new Configuration();
        Properties hlp = new Properties();
        FileInputStream fis = null;
        try {
            if (configfile.canRead()) {
                fis = new FileInputStream(configfile);
                hlp.load(fis);
                Iterator<Map.Entry<Object, Object>> i = hlp.entrySet().iterator();
                while (i.hasNext()) {
                    ConfigurationStorage.setProperty(c, i.next());
                }
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Configuration c, File configfile) throws IOException {
        Properties hlp = new Properties();
        hlp.put(KEY_INDIR, c.getInDir());
        hlp.put(KEY_OUTDIR, c.getOutDir());
        hlp.put(KEY_LIBDIR, c.getLibDir());
        hlp.put(KEY_PATTERN, c.getPattern());
        hlp.put(KEY_CMD_RUNNER, c.getRunnerCommand());
        hlp.put(KEY_CMD_OPEN, c.getOpenCommand());
        hlp.put(KEY_CMD_EDIT, c.getEditCommand());
        hlp.put(KEY_RUNNER_WD, c.getRunnerWorkingDir());
        FileOutputStream fos = new FileOutputStream(configfile);
        try {
            hlp.store(fos, null);
        }
        finally {
            fos.close();
        }
    }

    private static void setProperty(Configuration c, Map.Entry entry) {
        String key = (String)entry.getKey();
        String value = (String)entry.getValue();
        if (KEY_INDIR.equals(key)) {
            c.inDir = value;
        } else if (KEY_OUTDIR.equals(key)) {
            c.outDir = value;
        } else if (KEY_LIBDIR.equals(key)) {
            c.libDir = value;
        } else if (KEY_PATTERN.equals(key)) {
            c.pattern = value;
        } else if (KEY_CMD_RUNNER.equals(key)) {
            c.runnerCommand = value;
        } else if (KEY_CMD_OPEN.equals(key)) {
            c.openCommand = value;
        } else if (KEY_CMD_EDIT.equals(key)) {
            c.editCommand = value;
        } else if (KEY_RUNNER_WD.equals(key)) {
            c.runnerWorkingDir = value;
        } else {
            System.err.println("Configuration property " + key + " is not supported. Entry ignored");
        }
    }

    class OpenConfigurationAction
    extends AbstractAsyncAction {
        int newOrExisting;

        OpenConfigurationAction(int newOrExisting, GlobalLockCoordinator lockCoordinator) {
            this.newOrExisting = newOrExisting;
            this.setLockCoordinator(lockCoordinator);
        }

        protected boolean isActionEnabled() {
            return !this.getLockCoordinator().isReadingFilesystem() && !this.getLockCoordinator().isRunnerIsRunning();
        }

        public void doActionPerformed(ActionEvent e) {
            Configuration c = null;
            File selected = ConfigurationStorage.this.showOpenDialog(this.newOrExisting);
            if (selected != null) {
                try {
                    if (this.newOrExisting == 1) {
                        c = new Configuration();
                        ConfigurationStorage.save(c, selected);
                    }
                    ConfigurationStorage.this.setCurrentConfiguration(selected);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }
    }
}

