/*
 * Decompiled with CFR 0.152.
 */
package fit.guirunner;

import java.io.File;

public class Configuration {
    String inDir;
    String outDir;
    String libDir;
    String runnerWorkingDir;
    String pattern;
    String runnerCommand;
    String openCommand;
    String editCommand;
    File configurationFile;

    public Configuration() {
        this("in", "out", "lib");
    }

    public Configuration(String inDir, String outDir, String libDir) {
        this(inDir, outDir, libDir, "*.html", "java -cp \"${classpath}\" fit.FileRunner \"${infile}\" \"${outfile}\"");
    }

    public Configuration(String inDir, String outDir, String libDir, String pattern, String runnerCommand) {
        this.inDir = inDir;
        this.outDir = outDir;
        this.libDir = libDir;
        this.pattern = pattern;
        this.runnerCommand = runnerCommand;
        this.editCommand = "cmd /c start \"Start...\" winword /n \"${infile}\"";
        this.openCommand = "cmd /c start \"Start...\" \"${outfile}\"";
    }

    public Configuration(String inDir, String outDir, String libDir, String pattern, String runnerCommand, String openCommand, String editCommand, String runnerWorkingDir) {
        this.inDir = inDir;
        this.outDir = outDir;
        this.libDir = libDir;
        this.pattern = pattern;
        this.runnerCommand = runnerCommand;
        this.openCommand = openCommand;
        this.editCommand = editCommand;
        this.runnerWorkingDir = runnerWorkingDir;
    }

    public String getInDir() {
        return this.inDir;
    }

    public String getLibDir() {
        return this.libDir;
    }

    public String getOutDir() {
        return this.outDir;
    }

    public String getRunnerCommand() {
        return this.runnerCommand;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getEditCommand() {
        return this.editCommand;
    }

    public String getOpenCommand() {
        return this.openCommand;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Configuration={\ninDir=").append(this.inDir).append("\n");
        sb.append("outDir=").append(this.outDir).append("\n");
        sb.append("libDir=").append(this.libDir).append("\n");
        sb.append("pattern=").append(this.pattern).append("\n");
        sb.append("runnerCmd=").append(this.runnerCommand).append("\n");
        sb.append("openCmd=").append(this.openCommand).append("\n");
        sb.append("editCmd=").append(this.editCommand).append("\n");
        sb.append("runnerWorkingDir=").append(this.runnerWorkingDir).append("\n}\n");
        return sb.toString();
    }

    public String getConfigurationName() {
        return this.configurationFile != null ? this.configurationFile.getName() : "";
    }

    public void setConfigurationName(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public File getConfigurationDir() {
        return this.getConfigurationFile() != null ? this.getConfigurationFile().getParentFile() : null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.configurationFile == null ? 0 : this.configurationFile.hashCode());
        result = 31 * result + (this.editCommand == null ? 0 : this.editCommand.hashCode());
        result = 31 * result + (this.inDir == null ? 0 : this.inDir.hashCode());
        result = 31 * result + (this.libDir == null ? 0 : this.libDir.hashCode());
        result = 31 * result + (this.openCommand == null ? 0 : this.openCommand.hashCode());
        result = 31 * result + (this.outDir == null ? 0 : this.outDir.hashCode());
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.runnerCommand == null ? 0 : this.runnerCommand.hashCode());
        result = 31 * result + (this.runnerWorkingDir == null ? 0 : this.runnerWorkingDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.configurationFile == null ? other.configurationFile != null : !this.configurationFile.equals(other.configurationFile)) {
            return false;
        }
        if (this.editCommand == null ? other.editCommand != null : !this.editCommand.equals(other.editCommand)) {
            return false;
        }
        if (this.inDir == null ? other.inDir != null : !this.inDir.equals(other.inDir)) {
            return false;
        }
        if (this.libDir == null ? other.libDir != null : !this.libDir.equals(other.libDir)) {
            return false;
        }
        if (this.openCommand == null ? other.openCommand != null : !this.openCommand.equals(other.openCommand)) {
            return false;
        }
        if (this.outDir == null ? other.outDir != null : !this.outDir.equals(other.outDir)) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern)) {
            return false;
        }
        if (this.runnerCommand == null ? other.runnerCommand != null : !this.runnerCommand.equals(other.runnerCommand)) {
            return false;
        }
        return !(this.runnerWorkingDir == null ? other.runnerWorkingDir != null : !this.runnerWorkingDir.equals(other.runnerWorkingDir));
    }

    public String getRunnerWorkingDir() {
        return this.runnerWorkingDir;
    }
}

