/*
 * Decompiled with CFR 0.152.
 */
package fit;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.SkyBluer;
import fit.CommandLineParameters;
import fit.ReloadUponConfigurationChanged;
import fit.guirunner.ConfigurationStorage;
import fit.guirunner.EnvironmentContext;
import fit.guirunner.GuiRunnerActions;
import fit.guirunner.Resources;
import fit.guirunner.RunnerEntry;
import fit.guirunner.RunnerFrame;
import fit.guirunner.RunnerTableModel;
import fit.guirunner.Summary;
import fit.guirunner.UserPreferences;
import fit.guirunner.actions.AbstractAsyncAction;
import fit.guirunner.actions.ReloadAction;
import fit.guirunner.logic.ExecuteEntry;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GuiRunner
implements Runnable,
GuiRunnerActions {
    public static final String RESOURCE = "fit.guirunner.resource.GuiRunner";
    public static final String DEFAULT_PREFERENCES_FILENAME = ".fit.GuiRunner.properties";
    Resources resources;
    ConfigurationStorage configStorage;

    GuiRunner() {
        this(new Resources(null, RESOURCE, GuiRunner.defaultPreferences()));
    }

    GuiRunner(Resources resoruces) {
        this.resources = resoruces;
        this.configStorage = new ConfigurationStorage(resoruces);
    }

    public static void main(String[] args) {
        CommandLineParameters params = new CommandLineParameters(args, GuiRunner.getLastKnownConfiguration());
        switch (params.getCommand()) {
            case 0: {
                params.printUsageAndExit(System.err);
                break;
            }
            case 3: {
                GuiRunner.startCli(params.getConfname());
                break;
            }
            case 1: {
                GuiRunner.startApp(params.getConfname());
                break;
            }
            case 4: {
                GuiRunner.startApp(null);
                break;
            }
        }
    }

    public static void startApp(String confname) {
        GuiRunner theApp = new GuiRunner();
        theApp.setCurrentConfiguration(confname);
        SwingUtilities.invokeLater(theApp);
    }

    public static void startCli(String confname) {
        GuiRunner theApp = new GuiRunner();
        theApp.setCurrentConfiguration(confname);
        int retval = theApp.runCli();
        System.exit(retval);
    }

    public static UserPreferences defaultPreferences() {
        return new UserPreferences(System.getProperty("user.home") + File.separator + DEFAULT_PREFERENCES_FILENAME);
    }

    public void run() {
        this.configureUI();
        RunnerTableModel model = new RunnerTableModel(this.resources.getResource());
        ReloadAction reloadAction = new ReloadAction(model, this.resources);
        this.resources.getResource().configureActionFromResource(reloadAction, "REFRESH_ENTRIES");
        this.resources.getActionMap().put("REFRESH_ENTRIES", reloadAction);
        new ReloadUponConfigurationChanged(this.resources.getLockCoordinator(), reloadAction);
        AbstractAsyncAction action = this.configStorage.getNewConfigurationAction("NEW_CONFIG");
        this.resources.getActionMap().put("NEW_CONFIG", action);
        action = this.configStorage.getOpenConfigurationAction("OPEN_CONFIG");
        this.resources.getActionMap().put("OPEN_CONFIG", action);
        action = this.configStorage.getEditConfigurationAction("EDIT_CONFIG");
        this.resources.getActionMap().put("EDIT_CONFIG", action);
        action.setLockCoordinator(this.resources.getLockCoordinator());
        RunnerFrame frame = new RunnerFrame(model, this.resources);
        frame.pack();
        frame.setVisible(true);
        if (this.resources.getLockCoordinator().isHavingConfiguration()) {
            ((AbstractAsyncAction)reloadAction).doActionPerformed(null);
        }
    }

    public int runCli() {
        RunnerTableModel model = new RunnerTableModel(this.resources.getResource());
        int retval = -1;
        ReloadAction action = new ReloadAction(model, this.resources);
        ((AbstractAsyncAction)action).doActionPerformed(null);
        if (model.getRowCount() > 0) {
            try {
                EnvironmentContext ctx = new EnvironmentContext(this.resources.getConfiguration());
                ExecuteEntry execute = new ExecuteEntry(ctx.getRunnerCmd(), ctx.getWorkDirPattern(), ctx.getWorkingDir(), ctx.getInDir(), ctx.getOutDir());
                Iterator i = model.getEntries().iterator();
                while (i.hasNext()) {
                    RunnerEntry re = (RunnerEntry)i.next();
                    execute.doExecute(re);
                }
                Summary summary = new Summary(model);
                System.err.println(summary.toString());
                retval = summary.getWrong() + summary.getExceptions();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    public void setCurrentConfiguration(String filename) {
        this.configStorage.setCurrentConfiguration(filename);
    }

    public static String getLastKnownConfiguration() {
        return GuiRunner.defaultPreferences().getProperty("ConfigurationStorage.currentConfiguration");
    }

    private void configureUI() {
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        Options.setDefaultIconSize(new Dimension(20, 20));
        try {
            if (LookUtils.IS_OS_WINDOWS_XP) {
                PlasticXPLookAndFeel.setCurrentTheme(new SkyBluer());
                UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
            } else if (LookUtils.IS_OS_WINDOWS_2000) {
                UIManager.setLookAndFeel(Options.getCrossPlatformLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(Options.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            System.err.println("Can't set look & feel:" + e);
        }
    }
}

