/*
 * Decompiled with CFR 0.152.
 */
package fit;

import fit.guirunner.RunnerVersion;
import java.io.File;
import java.io.PrintStream;

class CommandLineParameters
implements RunnerVersion {
    public static final int CMD_HELP = 0;
    public static final int CMD_DEFAULT = 1;
    public static final int CMD_CLI_RUNNER = 3;
    public static final int CMD_ASK_USER = 4;
    public static final String DEFAULT_CONFNAME = "guirunner.conf";
    int command;
    String confname;

    CommandLineParameters(String[] args, String lastKnownConfiguration) {
        this.confname = lastKnownConfiguration == null ? DEFAULT_CONFNAME : lastKnownConfiguration;
        this.command = 1;
        int confIdx = -1;
        if (args.length == 1 || args.length == 2) {
            if ("-h".equals(args[0])) {
                this.command = 0;
            } else if ("-cli".equals(args[0])) {
                this.command = 3;
                this.confname = null;
                confIdx = 1;
            } else {
                confIdx = 0;
            }
        }
        if (confIdx >= 0 && confIdx < args.length) {
            this.confname = args[confIdx];
        }
        if (!(this.command != 3 || this.confname != null && new File(this.confname).exists())) {
            this.command = 0;
        }
        if (this.command == 1 && !new File(this.confname).exists()) {
            this.command = 4;
        }
    }

    public void printUsageAndExit(PrintStream w) {
        w.println("GuiRunner [-h] [-cli] [confname]");
        w.println(" -h    help");
        w.println(" -cli  no gui, just run and show summary,");
        w.println("       confname must be given");
        w.println(" confname filename of the configuration.");
        w.println(" (default: guirunner.conf)");
        w.println(" Version:  010");
        w.println(" ID:       $Id: RunnerVersion.java,v 1.7 2008/06/09 09:08:27 mbusik Exp $");
        w.println(" (C) Martin Busik 2007, 2008 This Software is GPL.");
        System.exit(1);
    }

    public int getCommand() {
        return this.command;
    }

    public String getConfname() {
        return this.confname;
    }
}

